/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.test.TestGraphDatabaseFactory;

public class DbRepresentation {
    private final Map<Long, NodeRep> nodes = new TreeMap<Long, NodeRep>();
    private final Set<IndexDefinition> schemaIndexes = new HashSet<IndexDefinition>();
    private final Set<ConstraintDefinition> constraints = new HashSet<ConstraintDefinition>();
    private long highestNodeId;
    private long highestRelationshipId;

    public static DbRepresentation of(GraphDatabaseService db) {
        return DbRepresentation.of(db, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DbRepresentation of(GraphDatabaseService db, boolean includeIndexes) {
        int retryCount = 5;
        while (true) {
            try (Transaction ignore = db.beginTx();){
                DbRepresentation result = new DbRepresentation();
                for (Node node : db.getAllNodes()) {
                    NodeRep nodeRep = new NodeRep(db, node, includeIndexes);
                    result.nodes.put(node.getId(), nodeRep);
                    result.highestNodeId = Math.max(node.getId(), result.highestNodeId);
                    result.highestRelationshipId = Math.max(nodeRep.highestRelationshipId, result.highestRelationshipId);
                }
                for (IndexDefinition indexDefinition : db.schema().getIndexes()) {
                    result.schemaIndexes.add(indexDefinition);
                }
                for (ConstraintDefinition constraintDefinition : db.schema().getConstraints()) {
                    result.constraints.add(constraintDefinition);
                }
                DbRepresentation dbRepresentation = result;
                return dbRepresentation;
            }
            catch (TransactionFailureException e) {
                if (retryCount-- >= 0) continue;
                throw e;
            }
            break;
        }
    }

    public static DbRepresentation of(File storeDir) {
        return DbRepresentation.of(storeDir, true, Config.defaults());
    }

    public static DbRepresentation of(File storeDir, Config config) {
        return DbRepresentation.of(storeDir, true, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbRepresentation of(File storeDir, boolean includeIndexes, Config config) {
        GraphDatabaseBuilder builder = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(storeDir);
        builder.setConfig(config.getRaw());
        GraphDatabaseService db = builder.newGraphDatabase();
        try {
            DbRepresentation dbRepresentation = DbRepresentation.of(db, includeIndexes);
            return dbRepresentation;
        }
        finally {
            db.shutdown();
        }
    }

    public boolean equals(Object obj) {
        return this.compareWith((DbRepresentation)obj).isEmpty();
    }

    public Collection<String> compareWith(DbRepresentation other) {
        ArrayList<String> diffList = new ArrayList<String>();
        CollectionDiffReport diff = new CollectionDiffReport(diffList);
        this.nodeDiff(other, diff);
        this.indexDiff(other, diff);
        this.constraintDiff(other, diff);
        return diffList;
    }

    private void constraintDiff(DbRepresentation other, DiffReport diff) {
        for (ConstraintDefinition constraint : this.constraints) {
            if (other.constraints.contains(constraint)) continue;
            diff.add("I have constraint " + constraint + " which other doesn't");
        }
        for (ConstraintDefinition otherConstraint : other.constraints) {
            if (this.constraints.contains(otherConstraint)) continue;
            diff.add("Other has constraint " + otherConstraint + " which I don't");
        }
    }

    private void indexDiff(DbRepresentation other, DiffReport diff) {
        for (IndexDefinition schemaIndex : this.schemaIndexes) {
            if (other.schemaIndexes.contains(schemaIndex)) continue;
            diff.add("I have schema index " + schemaIndex + " which other doesn't");
        }
        for (IndexDefinition otherSchemaIndex : other.schemaIndexes) {
            if (this.schemaIndexes.contains(otherSchemaIndex)) continue;
            diff.add("Other has schema index " + otherSchemaIndex + " which I don't");
        }
    }

    private void nodeDiff(DbRepresentation other, DiffReport diff) {
        for (NodeRep node : this.nodes.values()) {
            NodeRep otherNode = other.nodes.get(node.id);
            if (otherNode == null) {
                diff.add("I have node " + node.id + " which other doesn't");
                continue;
            }
            node.compareWith(otherNode, diff);
        }
        for (Long id : other.nodes.keySet()) {
            if (this.nodes.containsKey(id)) continue;
            diff.add("Other has node " + id + " which I don't");
        }
    }

    public int hashCode() {
        return this.nodes.hashCode();
    }

    public String toString() {
        return this.nodes.toString();
    }

    private static class CollectionDiffReport
    implements DiffReport {
        private final Collection<String> collection;

        CollectionDiffReport(Collection<String> collection) {
            this.collection = collection;
        }

        @Override
        public void add(String report) {
            this.collection.add(report);
        }
    }

    private static interface DiffReport {
        public void add(String var1);
    }

    private static class PropertiesRep {
        private final Map<String, Serializable> props = new HashMap<String, Serializable>();
        private final String entityToString;
        private final long entityId;

        PropertiesRep(PropertyContainer entity, long id) {
            this.entityId = id;
            this.entityToString = entity.toString();
            for (String key : entity.getPropertyKeys()) {
                Serializable value = (Serializable)entity.getProperty(key, null);
                if (value == null) continue;
                if (value.getClass().isArray()) {
                    this.props.put(key, new ArrayList<Object>(Arrays.asList(IoPrimitiveUtils.asArray((Object)value))));
                    continue;
                }
                this.props.put(key, value);
            }
        }

        protected void compareWith(PropertiesRep other, DiffReport diff) {
            boolean equals = this.props.equals(other.props);
            if (!equals) {
                diff.add("Properties diff for " + this.entityToString + " mine:" + this.props + ", other:" + other.props);
            }
        }

        public int hashCode() {
            return this.props.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertiesRep that = (PropertiesRep)o;
            return Objects.equals(this.props, that.props);
        }

        public String toString() {
            return this.props.toString();
        }
    }

    private static class NodeRep {
        private final PropertiesRep properties;
        private final Map<Long, PropertiesRep> outRelationships = new HashMap<Long, PropertiesRep>();
        private final long highestRelationshipId;
        private final long id;
        private final Map<String, Map<String, Serializable>> index;

        NodeRep(GraphDatabaseService db, Node node, boolean includeIndexes) {
            this.id = node.getId();
            this.properties = new PropertiesRep((PropertyContainer)node, node.getId());
            long highestRel = 0L;
            for (Relationship rel : node.getRelationships(Direction.OUTGOING)) {
                this.outRelationships.put(rel.getId(), new PropertiesRep((PropertyContainer)rel, rel.getId()));
                highestRel = Math.max(highestRel, rel.getId());
            }
            this.highestRelationshipId = highestRel;
            this.index = includeIndexes ? this.checkIndex(db) : null;
        }

        private Map<String, Map<String, Serializable>> checkIndex(GraphDatabaseService db) {
            HashMap<String, Map<String, Serializable>> result = new HashMap<String, Map<String, Serializable>>();
            for (String indexName : db.index().nodeIndexNames()) {
                HashMap thisIndex = new HashMap();
                Index tempIndex = db.index().forNodes(indexName);
                block10: for (Map.Entry property : this.properties.props.entrySet()) {
                    IndexHits content = tempIndex.get((String)property.getKey(), property.getValue());
                    Throwable throwable = null;
                    try {
                        if (!content.hasNext()) continue;
                        for (Node hit : content) {
                            if (hit.getId() != this.id) continue;
                            thisIndex.put(property.getKey(), property.getValue());
                            continue block10;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (content == null) continue;
                        if (throwable != null) {
                            try {
                                content.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        content.close();
                    }
                }
                result.put(indexName, thisIndex);
            }
            return result;
        }

        private void compareIndex(NodeRep other, DiffReport diff) {
            if (other.index == this.index) {
                return;
            }
            HashSet<String> allIndexes = new HashSet<String>();
            allIndexes.addAll(this.index.keySet());
            allIndexes.addAll(other.index.keySet());
            for (String indexName : allIndexes) {
                if (!this.index.containsKey(indexName)) {
                    diff.add(this + " isn't indexed in " + indexName + " for mine");
                    continue;
                }
                if (!other.index.containsKey(indexName)) {
                    diff.add(this + " isn't indexed in " + indexName + " for other");
                    continue;
                }
                Map<String, Serializable> thisIndex = this.index.get(indexName);
                Map<String, Serializable> otherIndex = other.index.get(indexName);
                if (thisIndex.size() != otherIndex.size()) {
                    diff.add("other index had a different mapping count than me for node " + this + " mine:" + thisIndex + ", other:" + otherIndex);
                    continue;
                }
                for (Map.Entry<String, Serializable> indexEntry : thisIndex.entrySet()) {
                    if (indexEntry.getValue().equals(otherIndex.get(indexEntry.getKey()))) continue;
                    diff.add("other index had a different value indexed for " + indexEntry.getKey() + "=" + indexEntry.getValue() + ", namely " + otherIndex.get(indexEntry.getKey()) + " for " + this);
                }
            }
        }

        void compareWith(NodeRep other, DiffReport diff) {
            if (other.id != this.id) {
                diff.add("Id differs mine:" + this.id + ", other:" + other.id);
            }
            this.properties.compareWith(other.properties, diff);
            if (this.index != null && other.index != null) {
                this.compareIndex(other, diff);
            }
            this.compareRelationships(other, diff);
        }

        private void compareRelationships(NodeRep other, DiffReport diff) {
            for (PropertiesRep rel : this.outRelationships.values()) {
                PropertiesRep otherRel = other.outRelationships.get(rel.entityId);
                if (otherRel == null) {
                    diff.add("I have relationship " + rel.entityId + " which other don't");
                    continue;
                }
                rel.compareWith(otherRel, diff);
            }
            for (Long id : other.outRelationships.keySet()) {
                if (this.outRelationships.containsKey(id)) continue;
                diff.add("Other has relationship " + id + " which I don't");
            }
        }

        public int hashCode() {
            int result = 7;
            result += this.properties.hashCode() * 7;
            result += this.outRelationships.hashCode() * 13;
            result = (int)((long)result + this.id * 17L);
            if (this.index != null) {
                result += this.index.hashCode() * 19;
            }
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeRep nodeRep = (NodeRep)o;
            return this.id == nodeRep.id && Objects.equals(this.properties, nodeRep.properties) && Objects.equals(this.outRelationships, nodeRep.outRelationships) && Objects.equals(this.index, nodeRep.index);
        }

        public String toString() {
            return "<id: " + this.id + " props: " + this.properties + ", rels: " + this.outRelationships + ", index: " + this.index + ">";
        }
    }
}

