/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric;

import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.fabric.transaction.TransactionManager;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.event.DatabaseEventContext;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.graphdb.event.DatabaseEventListenerAdapter;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class TransactionManagerIT {
    @Inject
    private DatabaseManagementService databaseManagementService;
    @Inject
    private GraphDatabaseAPI database;

    TransactionManagerIT() {
    }

    @Test
    void failToStartFabricTransactionAfterShutdown() {
        final TransactionManager transactionManager = (TransactionManager)this.database.getDependencyResolver().resolveDependency(TransactionManager.class);
        final AtomicBoolean invocationWitness = new AtomicBoolean(false);
        this.databaseManagementService.registerDatabaseEventListener((DatabaseEventListener)new DatabaseEventListenerAdapter(){

            public void databaseShutdown(DatabaseEventContext eventContext) {
                Assertions.assertThrows(DatabaseShutdownException.class, () -> transactionManager.begin(null, null));
                invocationWitness.set(true);
            }
        });
        this.databaseManagementService.shutdown();
        Assertions.assertTrue((boolean)invocationWitness.get());
    }
}

