/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric;

import java.net.URI;
import java.net.URISyntaxException;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.internal.helpers.HostnamePort;

public class DriverUtils {
    public static Driver createDriver(ConnectorPortRegister portRegister) {
        return GraphDatabase.driver((URI)DriverUtils.getBoltRoutingUri(portRegister), (AuthToken)AuthTokens.none(), (Config)Config.builder().withoutEncryption().withMaxConnectionPoolSize(3).build());
    }

    private static URI getBoltRoutingUri(ConnectorPortRegister portRegister) {
        return DriverUtils.getBoltUri(portRegister, "neo4j");
    }

    private static URI getBoltDirectUri(ConnectorPortRegister portRegister) {
        return DriverUtils.getBoltUri(portRegister, "bolt");
    }

    private static URI getBoltUri(ConnectorPortRegister portRegister, String scheme) {
        HostnamePort hostPort = portRegister.getLocalAddress("bolt");
        try {
            return new URI(scheme, null, hostPort.getHost(), hostPort.getPort(), null, null, null);
        }
        catch (URISyntaxException x) {
            throw new IllegalArgumentException(x.getMessage(), x);
        }
    }
}

