/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.TransientException;
import org.neo4j.driver.types.Path;
import org.neo4j.exceptions.KernelException;
import org.neo4j.fabric.DriverUtils;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.helpers.Strings;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.BoltDbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@BoltDbmsExtension(configurationCallback="configure")
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
class SnapshotExecutionTest {
    @Inject
    private static GraphDatabaseAPI graphDatabase;
    @Inject
    private static ConnectorPortRegister connectorPortRegister;
    @Inject
    private static GlobalProcedures procedureRegistry;
    private static Driver driver;

    SnapshotExecutionTest() {
    }

    @ExtensionCallback
    static void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseInternalSettings.snapshot_query, (Object)true);
    }

    @BeforeAll
    static void beforeAll() throws KernelException {
        driver = DriverUtils.createDriver(connectorPortRegister);
        procedureRegistry.registerProcedure(ConcurrentQuery.class);
    }

    @AfterAll
    static void afterAll() {
        driver.close();
    }

    @BeforeEach
    void beforeEach() {
        try (Transaction tx = driver.session().beginTransaction();){
            tx.run("MATCH (n) DETACH DELETE n");
            tx.run("CREATE (:First {number: 0})").consume();
            tx.run("CREATE (:Second {number: 0})").consume();
            tx.commit();
        }
    }

    @Test
    void testBasicSnapshotRead() {
        String query = Strings.joinAsLines((String[])new String[]{"MATCH (f:First)", "WITH f.number AS f", "CALL se.doConcurrently('MATCH (f:First)\n SET f.number=1')", "CALL se.doConcurrently('MATCH (s:Second)\n SET s.number=1')", "MATCH (s:Second)", "RETURN f, s.number AS s"});
        List result = driver.session().run(query).stream().map(r -> List.of(Integer.valueOf(r.get("f", -1)), Integer.valueOf(r.get("s", -1)))).findFirst().get();
        org.junit.jupiter.api.Assertions.assertEquals(List.of(Integer.valueOf(1), Integer.valueOf(1)), (Object)result);
    }

    @Test
    void testRetryWhenEntityDeleted() {
        String query = Strings.joinAsLines((String[])new String[]{"MATCH (f:First)", "WITH f AS f", "CALL se.doConcurrently('MATCH (f:First)\nDELETE f')", "RETURN f"});
        List result = driver.session().run(query).list();
        org.junit.jupiter.api.Assertions.assertEquals(List.of(), (Object)result);
    }

    @Test
    void testDoNotRetryWrites() {
        String query = Strings.joinAsLines((String[])new String[]{"MATCH (f:First)", "SET f.number=3", "WITH f.number AS f", "CALL se.doConcurrently('MATCH (s:Second)\n SET s.number=1')", "MATCH (s:Second)", "RETURN f, s.number AS s"});
        TransientException e = (TransientException)org.junit.jupiter.api.Assertions.assertThrows(TransientException.class, () -> driver.session().run(query).list());
        Assertions.assertThat((Throwable)e).hasMessageContaining("Unable to get clean data snapshot for query 'MATCH (f:First)").hasMessageContaining("RETURN f AS f, s.number AS s' that performs updates.");
    }

    @Test
    void testCollectionVirtualTypes() {
        String query = "RETURN { key: 'Hello', listKey: [{ inner: 'Map1' }, { inner: 'Map2' }]} AS m";
        Value m = driver.session().run(query).stream().map(r -> r.get("m")).findFirst().get();
        Value expected = Values.value(Map.of("key", "Hello", "listKey", List.of(Map.of("inner", "Map1"), Map.of("inner", "Map2"))));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)m);
    }

    @Test
    void testEntityVirtualTypes() {
        String query = Strings.joinAsLines((String[])new String[]{"CREATE (n1:LABEL_1), (n2:LABEL_2)", "MERGE (n1) - [:TYPE_1] -> (n2)", "RETURN () - [] -> ()[0] AS p"});
        Path p = driver.session().run(query).stream().map(r -> r.get("p")).findFirst().get().asPath();
        Assertions.assertThat((Iterable)p.start().labels()).containsExactly((Object[])new String[]{"LABEL_1"});
        Assertions.assertThat((Iterable)p.end().labels()).containsExactly((Object[])new String[]{"LABEL_2"});
    }

    @Test
    void testErrorInExecutionPhaseOfTheQuery() {
        String query = "UNWIND[1, 0] AS a RETURN b";
        ClientException e = (ClientException)org.junit.jupiter.api.Assertions.assertThrows(ClientException.class, () -> driver.session().run(query).list());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Status.Statement.SyntaxError.code().serialize(), (Object)e.code());
        Assertions.assertThat((Throwable)e).hasMessageContaining("Variable `b` not defined");
    }

    @Test
    void testErrorInResultStreamingPhaseOfTheQuery() {
        String query = Strings.joinAsLines((String[])new String[]{"UNWIND [3, 2, 1, 0] AS a", "RETURN 1/a AS a"});
        ClientException e = (ClientException)org.junit.jupiter.api.Assertions.assertThrows(ClientException.class, () -> driver.session().run(query).list());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Status.Statement.ArithmeticError.code().serialize(), (Object)e.code());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/ by zero", (Object)e.getMessage());
    }

    @Test
    void testResultStreaming() {
        String query = Strings.joinAsLines((String[])new String[]{"UNWIND range(0, 100) AS a", "RETURN a"});
        int receivedRecords = ((List)Flux.from((Publisher)driver.rxSession().run(query).records()).limitRate(5).take(50L).collectList().block()).size();
        org.junit.jupiter.api.Assertions.assertEquals((int)50, (int)receivedRecords);
    }

    public static class ConcurrentQuery {
        @Context
        public GraphDatabaseService db;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Procedure(mode=Mode.WRITE, name="se.doConcurrently")
        public void doConcurrently(@Name(value="query") String query) throws Exception {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            try {
                Future<?> future = executor.submit(() -> this.db.executeTransactionally(query));
                future.get();
            }
            finally {
                executor.shutdown();
            }
        }
    }
}

