/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection;

import java.util.Objects;

public class BoltProtocolVersion
implements Comparable<BoltProtocolVersion> {
    private final int majorVersion;
    private final int minorVersion;

    public BoltProtocolVersion(int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public static BoltProtocolVersion fromRawBytes(int rawVersion) {
        int major = rawVersion & 0xFF;
        int minor = rawVersion >> 8 & 0xFF;
        return new BoltProtocolVersion(major, minor);
    }

    public long getMinorVersion() {
        return this.minorVersion;
    }

    public long getMajorVersion() {
        return this.majorVersion;
    }

    public int toInt() {
        int shiftedMinor = this.minorVersion << 8;
        return shiftedMinor | this.majorVersion;
    }

    public int toIntRange(BoltProtocolVersion minVersion) {
        if (this.majorVersion != minVersion.majorVersion) {
            throw new IllegalArgumentException("Versions should be from the same major version");
        }
        if (this.minorVersion < minVersion.minorVersion) {
            throw new IllegalArgumentException("Max version should be newer than min version");
        }
        int range = this.minorVersion - minVersion.minorVersion;
        int shiftedRange = range << 16;
        return shiftedRange | this.toInt();
    }

    public String toString() {
        return String.format("%d.%d", this.majorVersion, this.minorVersion);
    }

    public int hashCode() {
        return Objects.hash(this.minorVersion, this.majorVersion);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoltProtocolVersion)) {
            return false;
        }
        BoltProtocolVersion other = (BoltProtocolVersion)o;
        return this.getMajorVersion() == other.getMajorVersion() && this.getMinorVersion() == other.getMinorVersion();
    }

    @Override
    public int compareTo(BoltProtocolVersion other) {
        int result = Integer.compare(this.majorVersion, other.majorVersion);
        if (result == 0) {
            return Integer.compare(this.minorVersion, other.minorVersion);
        }
        return result;
    }

    public static boolean isHttp(BoltProtocolVersion protocolVersion) {
        return protocolVersion.getMajorVersion() == 80L && protocolVersion.getMinorVersion() == 84L;
    }
}

