/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.message;

import java.time.Duration;
import java.util.Map;
import java.util.Set;
import org.neo4j.bolt.connection.AccessMode;
import org.neo4j.bolt.connection.AuthToken;
import org.neo4j.bolt.connection.NotificationConfig;
import org.neo4j.bolt.connection.TelemetryApi;
import org.neo4j.bolt.connection.TransactionType;
import org.neo4j.bolt.connection.message.BeginMessage;
import org.neo4j.bolt.connection.message.BeginMessageImpl;
import org.neo4j.bolt.connection.message.CommitMessage;
import org.neo4j.bolt.connection.message.CommitMessageImpl;
import org.neo4j.bolt.connection.message.DiscardMessage;
import org.neo4j.bolt.connection.message.DiscardMessageImpl;
import org.neo4j.bolt.connection.message.LogoffMessage;
import org.neo4j.bolt.connection.message.LogoffMessageImpl;
import org.neo4j.bolt.connection.message.LogonMessage;
import org.neo4j.bolt.connection.message.LogonMessageImpl;
import org.neo4j.bolt.connection.message.PullMessage;
import org.neo4j.bolt.connection.message.PullMessageImpl;
import org.neo4j.bolt.connection.message.ResetMessage;
import org.neo4j.bolt.connection.message.ResetMessageImpl;
import org.neo4j.bolt.connection.message.RollbackMessage;
import org.neo4j.bolt.connection.message.RollbackMessageImpl;
import org.neo4j.bolt.connection.message.RouteMessage;
import org.neo4j.bolt.connection.message.RouteMessageImpl;
import org.neo4j.bolt.connection.message.RunMessage;
import org.neo4j.bolt.connection.message.RunMessageImpl;
import org.neo4j.bolt.connection.message.TelemetryMessage;
import org.neo4j.bolt.connection.message.TelemetryMessageImpl;
import org.neo4j.bolt.connection.values.Value;

public final class Messages {
    private static final CommitMessage COMMIT_MESSAGE = new CommitMessageImpl();
    private static final RollbackMessage ROLLBACK_MESSAGE = new RollbackMessageImpl();
    private static final ResetMessage RESET_MESSAGE = new ResetMessageImpl();
    private static final LogoffMessage LOGOFF_MESSAGE = new LogoffMessageImpl();

    public static RouteMessage route(String databaseName, String impersonatedUser, Set<String> bookmarks) {
        return new RouteMessageImpl(databaseName, impersonatedUser, bookmarks);
    }

    public static BeginMessage beginTransaction(String databaseName, AccessMode accessMode, String impersonatedUser, Set<String> bookmarks, TransactionType transactionType, Duration txTimeout, Map<String, Value> txMetadata, NotificationConfig notificationConfig) {
        return new BeginMessageImpl(databaseName, accessMode, impersonatedUser, bookmarks, transactionType, txTimeout, txMetadata, notificationConfig);
    }

    public static RunMessage run(String databaseName, AccessMode accessMode, String impersonatedUser, Set<String> bookmarks, String query, Map<String, Value> parameters, Duration txTimeout, Map<String, Value> txMetadata, NotificationConfig notificationConfig) {
        RunMessageImpl.Extra extra = new RunMessageImpl.Extra(databaseName, accessMode, impersonatedUser, bookmarks, txTimeout, txMetadata, notificationConfig);
        return new RunMessageImpl(query, parameters, extra);
    }

    public static RunMessage run(String query, Map<String, Value> parameters) {
        return new RunMessageImpl(query, parameters, null);
    }

    public static PullMessage pull(long qid, long request) {
        return new PullMessageImpl(qid, request);
    }

    public static DiscardMessage discard(long qid, long number) {
        return new DiscardMessageImpl(qid, number);
    }

    public static CommitMessage commit() {
        return COMMIT_MESSAGE;
    }

    public static RollbackMessage rollback() {
        return ROLLBACK_MESSAGE;
    }

    public static ResetMessage reset() {
        return RESET_MESSAGE;
    }

    public static LogoffMessage logoff() {
        return LOGOFF_MESSAGE;
    }

    public static LogonMessage logon(AuthToken authToken) {
        return new LogonMessageImpl(authToken);
    }

    public static TelemetryMessage telemetry(TelemetryApi telemetryApi) {
        return new TelemetryMessageImpl(telemetryApi);
    }

    private Messages() {
    }
}

