/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.exception;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.bolt.connection.exception.BoltException;
import org.neo4j.bolt.connection.values.Value;

public class BoltGqlErrorException
extends BoltException {
    private static final long serialVersionUID = -1731084000671105197L;
    private final String gqlStatus;
    private final String statusDescription;
    private final Map<String, Value> diagnosticRecord;

    public BoltGqlErrorException(String message, String gqlStatus, String statusDescription, Map<String, Value> diagnosticRecord, Throwable cause) {
        super(message, cause);
        this.gqlStatus = Objects.requireNonNull(gqlStatus);
        this.statusDescription = Objects.requireNonNull(statusDescription);
        this.diagnosticRecord = Objects.requireNonNull(diagnosticRecord);
    }

    public String gqlStatus() {
        return this.gqlStatus;
    }

    public String statusDescription() {
        return this.statusDescription;
    }

    public Map<String, Value> diagnosticRecord() {
        return this.diagnosticRecord;
    }

    public Optional<BoltGqlErrorException> gqlCause() {
        return BoltGqlErrorException.findFirstGqlCause(this, BoltGqlErrorException.class);
    }

    private static <T extends Throwable> Optional<T> findFirstGqlCause(Throwable throwable, Class<T> targetCls) {
        Throwable cause = throwable.getCause();
        if (cause == null) {
            return Optional.empty();
        }
        if (cause.getClass().isAssignableFrom(targetCls)) {
            return Optional.of((Throwable)targetCls.cast(cause));
        }
        return BoltGqlErrorException.findFirstGqlCause(cause, targetCls);
    }
}

