/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection;

import java.util.Objects;
import java.util.Optional;
import org.neo4j.bolt.connection.DatabaseName;
import org.neo4j.bolt.connection.InternalDatabaseName;

public final class DatabaseNameUtil {
    static final String DEFAULT_DATABASE_NAME = null;
    public static final String SYSTEM_DATABASE_NAME = "system";
    private static final DatabaseName DEFAULT_DATABASE = new DatabaseName(){

        @Override
        public Optional<String> databaseName() {
            return Optional.empty();
        }

        @Override
        public String description() {
            return "<default database>";
        }
    };
    private static final DatabaseName SYSTEM_DATABASE = new InternalDatabaseName("system");

    private DatabaseNameUtil() {
    }

    public static DatabaseName defaultDatabase() {
        return DEFAULT_DATABASE;
    }

    public static DatabaseName systemDatabase() {
        return SYSTEM_DATABASE;
    }

    public static DatabaseName database(String name) {
        if (Objects.equals(name, DEFAULT_DATABASE_NAME)) {
            return DatabaseNameUtil.defaultDatabase();
        }
        if (Objects.equals(name, SYSTEM_DATABASE_NAME)) {
            return DatabaseNameUtil.systemDatabase();
        }
        return new InternalDatabaseName(name);
    }
}

