/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.messaging.v6;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Map;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.exception.BoltProtocolException;
import org.neo4j.bolt.connection.netty.impl.messaging.v5.ValueUnpackerV5;
import org.neo4j.bolt.connection.netty.impl.packstream.PackInput;
import org.neo4j.bolt.connection.values.Type;
import org.neo4j.bolt.connection.values.Value;
import org.neo4j.bolt.connection.values.ValueFactory;

final class ValueUnpackerV6
extends ValueUnpackerV5 {
    public ValueUnpackerV6(PackInput input, ValueFactory valueFactory) {
        super(input, valueFactory);
    }

    @Override
    protected Value unpackVector(long size) throws IOException {
        int sizeDivider;
        Class<Number> elementType;
        this.ensureCorrectStructSize(Type.VECTOR, 2, size);
        byte[] elementTypeBytes = this.unpacker.unpackBytes();
        if (elementTypeBytes.length != 1) {
            throw new BoltProtocolException("Expected 1 element type, but got " + elementTypeBytes.length);
        }
        byte elementTypeAsByte = elementTypeBytes[0];
        RawUnpacker rawUnpacker = switch (elementTypeAsByte) {
            case -53 -> {
                elementType = Long.TYPE;
                sizeDivider = 8;
                yield this.unpacker::unpackRawLong;
            }
            case -54 -> {
                elementType = Integer.TYPE;
                sizeDivider = 4;
                yield this.unpacker::unpackRawInt;
            }
            case -55 -> {
                elementType = Short.TYPE;
                sizeDivider = 2;
                yield this.unpacker::unpackRawShort;
            }
            case -56 -> {
                elementType = Byte.TYPE;
                sizeDivider = 1;
                yield this.unpacker::unpackRawByte;
            }
            case -63 -> {
                elementType = Double.TYPE;
                sizeDivider = 8;
                yield this.unpacker::unpackRawDouble;
            }
            case -58 -> {
                elementType = Float.TYPE;
                sizeDivider = 4;
                yield this.unpacker::unpackRawFloat;
            }
            default -> throw new BoltProtocolException("Unexpected element type " + elementTypeAsByte);
        };
        int lenght = this.unpacker.unpackBytesSize() / sizeDivider;
        Object array = Array.newInstance(elementType, lenght);
        for (int i = 0; i < lenght; ++i) {
            Array.set(array, i, rawUnpacker.unpackRaw());
        }
        return this.valueFactory.vector(elementType, array);
    }

    @Override
    protected Value unpackUnsupported(long size) throws IOException {
        this.ensureCorrectStructSize(Type.UNSUPPORTED, 4, size);
        String name = this.unpacker.unpackString();
        long minMajorBoltVersion = this.unpacker.unpackLong();
        long minMinorBoltVersion = this.unpacker.unpackLong();
        BoltProtocolVersion minProtocolVersion = new BoltProtocolVersion(Math.toIntExact(minMajorBoltVersion), Math.toIntExact(minMinorBoltVersion));
        Map<String, Value> extra = this.unpackMap();
        return this.valueFactory.unsupportedTypeData(name, minProtocolVersion, extra);
    }

    private static interface RawUnpacker {
        public Object unpackRaw() throws IOException;
    }
}

