/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import java.time.Clock;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.neo4j.bolt.connection.BoltCapability;
import org.neo4j.bolt.connection.BoltConnectionProvider;
import org.neo4j.bolt.connection.BoltConnectionProviderFactory;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.DefaultDomainNameResolver;
import org.neo4j.bolt.connection.DomainNameResolver;
import org.neo4j.bolt.connection.LoggingProvider;
import org.neo4j.bolt.connection.netty.impl.NettyBoltConnectionProvider;
import org.neo4j.bolt.connection.netty.impl.async.connection.EventLoopGroupFactory;
import org.neo4j.bolt.connection.netty.impl.async.connection.NettyTransport;
import org.neo4j.bolt.connection.observation.ObservationProvider;
import org.neo4j.bolt.connection.values.ValueFactory;

public final class NettyBoltConnectionProviderFactory
implements BoltConnectionProviderFactory {
    private static final Set<String> SUPPORTED_SCHEMES = Set.of("bolt", "bolt+s", "bolt+ssc", "neo4j", "neo4j+s", "neo4j+ssc");

    public boolean supports(String scheme) {
        return SUPPORTED_SCHEMES.contains(scheme);
    }

    public BoltConnectionProvider create(LoggingProvider loggingProvider, ValueFactory valueFactory, ObservationProvider observationProvider, Map<String, ?> additionalConfig) {
        Class<? extends Channel> channelClass;
        System.Logger logger = loggingProvider.getLog(this.getClass());
        boolean shutdownEventLoopGroupOnClose = false;
        LocalAddress localAddress = NettyBoltConnectionProviderFactory.getConfigEntry(logger, additionalConfig, "localAddress", LocalAddress.class, () -> null);
        Boolean fastOpen = NettyBoltConnectionProviderFactory.getConfigEntry(logger, additionalConfig, "enableFastOpen", Boolean.class, () -> false);
        EventLoopGroup eventLoopGroup = NettyBoltConnectionProviderFactory.getConfigEntry(logger, additionalConfig, "eventLoopGroup", EventLoopGroup.class, () -> null);
        if (eventLoopGroup == null) {
            EventLoopGroupFactory factory = this.createEventLoopGroupFactory(logger, localAddress, additionalConfig);
            Integer size = NettyBoltConnectionProviderFactory.getConfigEntry(logger, additionalConfig, "eventLoopThreads", Integer.class, () -> 0);
            if (fastOpen.booleanValue() && !factory.fastOpenAvailable()) {
                logger.log(System.Logger.Level.WARNING, "Fast Open is not supported and will be ignored");
                fastOpen = false;
            }
            eventLoopGroup = factory.newEventLoopGroup(size);
            channelClass = factory.channelClass();
            shutdownEventLoopGroupOnClose = true;
        } else {
            NettyTransport nettyTransport = this.determineTransportType(logger, localAddress, additionalConfig, "nio");
            logger.log(System.Logger.Level.TRACE, "Selected nettyTransport %s", nettyTransport);
            channelClass = nettyTransport.channelClass();
            if (fastOpen.booleanValue() && !nettyTransport.fastOpenAvailable()) {
                logger.log(System.Logger.Level.WARNING, "Fast Open is not supported and will be ignored");
                fastOpen = false;
            }
        }
        Clock clock = NettyBoltConnectionProviderFactory.getConfigEntry(logger, additionalConfig, "clock", Clock.class, Clock::systemUTC);
        DomainNameResolver domainNameResolver = NettyBoltConnectionProviderFactory.getConfigEntry(logger, additionalConfig, "domainNameResolver", DomainNameResolver.class, DefaultDomainNameResolver::getInstance);
        BoltProtocolVersion maxVersion = NettyBoltConnectionProviderFactory.getConfigEntry(logger, additionalConfig, "maxVersion", BoltProtocolVersion.class, () -> null);
        Set preferredCapabilities = NettyBoltConnectionProviderFactory.getConfigEntry(logger, additionalConfig, "preferredCapabilities", Set.class, Set::of);
        long preferredCapabilitiesMask = NettyBoltConnectionProviderFactory.toBoltCapabilitiesMask(preferredCapabilities);
        return new NettyBoltConnectionProvider(eventLoopGroup, channelClass, clock, domainNameResolver, localAddress, maxVersion, fastOpen, preferredCapabilitiesMask, loggingProvider, valueFactory, shutdownEventLoopGroupOnClose, observationProvider);
    }

    private EventLoopGroupFactory createEventLoopGroupFactory(System.Logger logger, LocalAddress localAddress, Map<String, ?> additionalConfig) {
        String eventLoopThreadNamePrefix = NettyBoltConnectionProviderFactory.getConfigEntry(logger, additionalConfig, "eventLoopThreadNamePrefix", String.class, () -> null);
        NettyTransport nettyTransport = this.determineTransportType(logger, localAddress, additionalConfig, "auto");
        logger.log(System.Logger.Level.TRACE, "Selected nettyTransport %s", nettyTransport);
        return new EventLoopGroupFactory(eventLoopThreadNamePrefix, nettyTransport);
    }

    private NettyTransport determineTransportType(System.Logger logger, LocalAddress localAddress, Map<String, ?> additionalConfig, String defaultNettyTransport) {
        String nettyTransport;
        return switch (nettyTransport = NettyBoltConnectionProviderFactory.getConfigEntry(logger, additionalConfig, "nettyTransport", String.class, () -> defaultNettyTransport)) {
            case "auto" -> {
                if (localAddress != null) {
                    yield NettyTransport.local();
                }
                if (NettyTransport.isIoUringAvailable()) {
                    yield NettyTransport.ioUring();
                }
                if (NettyTransport.isEpollAvailable()) {
                    yield NettyTransport.epoll();
                }
                if (NettyTransport.isKQueueAvailable()) {
                    yield NettyTransport.kqueue();
                }
                yield NettyTransport.nio();
            }
            case "nio" -> NettyTransport.nio();
            case "io_uring" -> NettyTransport.ioUring();
            case "epoll" -> NettyTransport.epoll();
            case "kqueue" -> NettyTransport.kqueue();
            case "local" -> NettyTransport.local();
            default -> throw new IllegalArgumentException("Unexpected nettyTransport value: " + nettyTransport);
        };
    }

    private static long toBoltCapabilitiesMask(Set<BoltCapability> boltConnectionCapabilities) {
        long mask = 0L;
        for (BoltCapability boltConnectionCapability : boltConnectionCapabilities) {
            int id = boltConnectionCapability.id();
            if (id < 1 || id > 64) {
                throw new IllegalArgumentException("Bolt capability id must be between 1 and 64: " + id);
            }
            mask |= 1L << id - 1;
        }
        return mask;
    }

    private static <T> T getConfigEntry(System.Logger logger, Map<String, ?> config, String key, Class<T> type, Supplier<T> defaultValue) {
        Object value = config.get(key);
        if (value == null) {
            logger.log(System.Logger.Level.TRACE, "No %s provided, will use default", key);
            return defaultValue.get();
        }
        if (type.isAssignableFrom(value.getClass())) {
            logger.log(System.Logger.Level.TRACE, "Found %s provided", key);
            return type.cast(value);
        }
        logger.log(System.Logger.Level.ERROR, "Found %s provided, but it is not of type %s", key, type);
        throw new IllegalArgumentException("Expected " + String.valueOf(type) + " but got " + String.valueOf(value.getClass()));
    }
}

