/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.async.connection;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslHandshakeTimeoutException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLHandshakeException;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.BoltServerAddress;
import org.neo4j.bolt.connection.LoggingProvider;
import org.neo4j.bolt.connection.exception.BoltConnectionInitialisationTimeoutException;
import org.neo4j.bolt.connection.exception.BoltServiceUnavailableException;
import org.neo4j.bolt.connection.netty.impl.async.connection.BoltProtocolUtil;
import org.neo4j.bolt.connection.netty.impl.async.connection.ChannelPipelineBuilder;
import org.neo4j.bolt.connection.netty.impl.async.connection.HandshakeHandler;
import org.neo4j.bolt.connection.netty.impl.async.inbound.ConnectTimeoutHandler;
import org.neo4j.bolt.connection.netty.impl.logging.ChannelActivityLogger;
import org.neo4j.bolt.connection.netty.impl.util.FutureUtil;
import org.neo4j.bolt.connection.values.ValueFactory;

public class ChannelConnectedListener
implements ChannelFutureListener {
    private final BoltServerAddress address;
    private final ChannelPipelineBuilder pipelineBuilder;
    private final CompletableFuture<Channel> handshakeCompletedFuture;
    private final BoltProtocolVersion maxVersion;
    private final LoggingProvider logging;
    private final ValueFactory valueFactory;
    private final long initialisationTimeoutMillis;
    private final CompletableFuture<Duration> sslHandshakeFuture;
    private final boolean appendBoltHanshake;

    public ChannelConnectedListener(BoltServerAddress address, ChannelPipelineBuilder pipelineBuilder, CompletableFuture<Channel> handshakeCompletedFuture, BoltProtocolVersion maxVersion, LoggingProvider logging, ValueFactory valueFactory, long initialisationTimeoutMillis, CompletableFuture<Duration> sslHandshakeFuture, boolean appendBoltHanshake) {
        this.address = address;
        this.pipelineBuilder = pipelineBuilder;
        this.handshakeCompletedFuture = handshakeCompletedFuture;
        this.maxVersion = maxVersion;
        this.logging = logging;
        this.valueFactory = Objects.requireNonNull(valueFactory);
        this.initialisationTimeoutMillis = initialisationTimeoutMillis;
        this.sslHandshakeFuture = Objects.requireNonNull(sslHandshakeFuture);
        this.appendBoltHanshake = appendBoltHanshake;
    }

    public void operationComplete(ChannelFuture future) {
        if (future.isSuccess()) {
            this.sslHandshakeFuture.whenComplete((handshakeDuration, throwable) -> {
                if (throwable != null) {
                    if ((throwable = FutureUtil.completionExceptionCause(throwable)) instanceof SslHandshakeTimeoutException) {
                        throwable = new BoltConnectionInitialisationTimeoutException("SSL handshake with %s timed out".formatted(this.address), throwable);
                    } else if (!(throwable instanceof SSLHandshakeException)) {
                        throwable = new BoltServiceUnavailableException("SSL handshake with %s failed".formatted(this.address), throwable);
                    }
                    this.handshakeCompletedFuture.completeExceptionally((Throwable)throwable);
                } else if (this.appendBoltHanshake) {
                    long boltHandshakeTimeoutMillis;
                    long sslHandshakeDurationMillis = handshakeDuration.toMillis();
                    if (this.initialisationTimeoutMillis > 0L) {
                        boltHandshakeTimeoutMillis = this.initialisationTimeoutMillis - sslHandshakeDurationMillis;
                        if (boltHandshakeTimeoutMillis <= 0L) {
                            this.handshakeCompletedFuture.completeExceptionally((Throwable)new BoltConnectionInitialisationTimeoutException("Failed to initialise connection to %s within %d milliseconds".formatted(this.address, this.initialisationTimeoutMillis)));
                            return;
                        }
                    } else {
                        boltHandshakeTimeoutMillis = this.initialisationTimeoutMillis;
                    }
                    Channel channel = future.channel();
                    ChannelActivityLogger log = new ChannelActivityLogger(channel, this.logging, this.getClass());
                    log.log(System.Logger.Level.TRACE, "Channel %s connected, initiating bolt handshake", channel);
                    ChannelPipeline pipeline = channel.pipeline();
                    if (boltHandshakeTimeoutMillis > 0L) {
                        pipeline.addFirst(new ChannelHandler[]{new ConnectTimeoutHandler(boltHandshakeTimeoutMillis, this.initialisationTimeoutMillis)});
                        this.handshakeCompletedFuture.whenComplete((ignored0, handshakeThrowable) -> {
                            if (handshakeThrowable == null) {
                                channel.pipeline().remove(ConnectTimeoutHandler.class);
                            }
                        });
                    }
                    pipeline.addLast(new ChannelHandler[]{new HandshakeHandler(this.pipelineBuilder, this.handshakeCompletedFuture, this.address, this.maxVersion, false, this.initialisationTimeoutMillis, this.logging, this.valueFactory)});
                    log.log(System.Logger.Level.DEBUG, "C: [Bolt Handshake] %s", BoltProtocolUtil.handshakeString());
                    channel.writeAndFlush((Object)BoltProtocolUtil.handshakeBuf()).addListener(f -> {
                        if (!f.isSuccess()) {
                            Throwable error = f.cause();
                            if (!(error instanceof SSLHandshakeException)) {
                                error = new BoltServiceUnavailableException(String.format("Unable to write Bolt handshake to %s.", this.address), error);
                            }
                            this.handshakeCompletedFuture.completeExceptionally(error);
                        }
                    });
                }
            });
        } else {
            this.handshakeCompletedFuture.completeExceptionally(ChannelConnectedListener.databaseUnavailableError(this.address, future.cause()));
        }
    }

    private static Throwable databaseUnavailableError(BoltServerAddress address, Throwable cause) {
        return new BoltServiceUnavailableException(String.format("Unable to connect to %s, ensure the database is running and that there is a working network connection to it.", address), cause);
    }
}

