/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.async.connection;

import io.netty.channel.Channel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.Objects;

public record NettyTransport(Type type, Class<? extends Channel> channelClass, boolean fastOpenAvailable) {
    private static final String EPOLL_NAME = "io.netty.channel.epoll.Epoll";
    private static final String KQUEUE_NAME = "io.netty.channel.kqueue.KQueue";

    public NettyTransport {
        Objects.requireNonNull(channelClass);
    }

    public static boolean isEpollAvailable() {
        try {
            Class.forName(EPOLL_NAME);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return Epoll.isAvailable();
    }

    public static boolean isKQueueAvailable() {
        try {
            Class.forName(KQUEUE_NAME);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return KQueue.isAvailable();
    }

    public static NettyTransport nio() {
        return new NettyTransport(Type.NIO, NioSocketChannel.class, false);
    }

    public static NettyTransport epoll() {
        return new NettyTransport(Type.EPOLL, EpollSocketChannel.class, Epoll.isTcpFastOpenClientSideAvailable());
    }

    public static NettyTransport kqueue() {
        return new NettyTransport(Type.KQUEUE, KQueueSocketChannel.class, KQueue.isTcpFastOpenClientSideAvailable());
    }

    public static NettyTransport local() {
        return new NettyTransport(Type.LOCAL, LocalChannel.class, false);
    }

    public static enum Type {
        NIO,
        EPOLL,
        KQUEUE,
        LOCAL;

    }
}

