/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.async.connection;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.local.LocalEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.FastThreadLocalThread;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import org.neo4j.bolt.connection.netty.impl.EventLoopThread;
import org.neo4j.bolt.connection.netty.impl.async.connection.NettyTransport;

public final class EventLoopGroupFactory {
    private static final String THREAD_NAME_PREFIX = "Neo4jDriverIO";
    private static final int THREAD_PRIORITY = 10;
    private static final boolean THREAD_IS_DAEMON = true;
    private final String threadNamePrefix;
    private final NettyTransport nettyTransport;

    public EventLoopGroupFactory(String threadNamePrefix, NettyTransport nettyTransport) {
        this.threadNamePrefix = Objects.requireNonNullElse(threadNamePrefix, THREAD_NAME_PREFIX);
        this.nettyTransport = Objects.requireNonNull(nettyTransport);
    }

    public Class<? extends Channel> channelClass() {
        return this.nettyTransport.channelClass();
    }

    public boolean fastOpenAvailable() {
        return this.nettyTransport.fastOpenAvailable();
    }

    public EventLoopGroup newEventLoopGroup(int threadCount) {
        return switch (this.nettyTransport.type()) {
            default -> throw new IncompatibleClassChangeError();
            case NettyTransport.Type.NIO -> new DriverEventLoopGroup(threadCount);
            case NettyTransport.Type.EPOLL -> new EpollEventLoopGroup(threadCount, (ThreadFactory)((Object)new DriverThreadFactory(this.threadNamePrefix)));
            case NettyTransport.Type.KQUEUE -> new KQueueEventLoopGroup(threadCount, (ThreadFactory)((Object)new DriverThreadFactory(this.threadNamePrefix)));
            case NettyTransport.Type.LOCAL -> new LocalEventLoopGroup(threadCount, (ThreadFactory)((Object)new DriverThreadFactory(this.threadNamePrefix)));
        };
    }

    public static void assertNotInEventLoopThread() throws IllegalStateException {
        if (EventLoopGroupFactory.isEventLoopThread(Thread.currentThread())) {
            throw new IllegalStateException("Blocking operation can't be executed in IO thread because it might result in a deadlock. Please do not use blocking API when chaining futures returned by async API methods.");
        }
    }

    public static boolean isEventLoopThread(Thread thread) {
        return thread instanceof EventLoopThread;
    }

    private class DriverEventLoopGroup
    extends NioEventLoopGroup {
        DriverEventLoopGroup(int nThreads) {
            super(nThreads);
        }

        protected ThreadFactory newDefaultThreadFactory() {
            return new DriverThreadFactory(EventLoopGroupFactory.this.threadNamePrefix);
        }
    }

    private static class DriverThreadFactory
    extends DefaultThreadFactory {
        DriverThreadFactory(String threadNamePrefix) {
            super(threadNamePrefix, true, 10);
        }

        protected Thread newThread(Runnable r, String name) {
            return new DriverThread(this.threadGroup, r, name);
        }
    }

    private static class DriverThread
    extends FastThreadLocalThread
    implements EventLoopThread {
        DriverThread(ThreadGroup group, Runnable target, String name) {
            super(group, target, name);
        }
    }
}

