/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Clock;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.bolt.connection.BoltAgent;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.BoltServerAddress;
import org.neo4j.bolt.connection.DomainNameResolver;
import org.neo4j.bolt.connection.LoggingProvider;
import org.neo4j.bolt.connection.NotificationConfig;
import org.neo4j.bolt.connection.SecurityPlan;
import org.neo4j.bolt.connection.netty.impl.ConnectionProvider;
import org.neo4j.bolt.connection.netty.impl.RoutingContext;
import org.neo4j.bolt.connection.netty.impl.async.NetworkConnection;
import org.neo4j.bolt.connection.netty.impl.async.connection.ChannelConnectedListener;
import org.neo4j.bolt.connection.netty.impl.async.connection.ChannelPipelineBuilderImpl;
import org.neo4j.bolt.connection.netty.impl.async.connection.NettyChannelInitializer;
import org.neo4j.bolt.connection.netty.impl.async.connection.NettyDomainNameResolverGroup;
import org.neo4j.bolt.connection.netty.impl.messaging.BoltProtocol;
import org.neo4j.bolt.connection.netty.impl.spi.Connection;
import org.neo4j.bolt.connection.netty.impl.util.FutureUtil;
import org.neo4j.bolt.connection.observation.BoltExchangeObservation;
import org.neo4j.bolt.connection.observation.ImmutableObservation;
import org.neo4j.bolt.connection.observation.ObservationProvider;
import org.neo4j.bolt.connection.values.Value;
import org.neo4j.bolt.connection.values.ValueFactory;

public final class NettyConnectionProvider
implements ConnectionProvider {
    private final EventLoopGroup eventLoopGroup;
    private final Clock clock;
    private final DomainNameResolver domainNameResolver;
    private final AddressResolverGroup<InetSocketAddress> addressResolverGroup;
    private final LocalAddress localAddress;
    private final BoltProtocolVersion maxVersion;
    private final LoggingProvider logging;
    private final ValueFactory valueFactory;
    private final ObservationProvider observationProvider;

    public NettyConnectionProvider(EventLoopGroup eventLoopGroup, Clock clock, DomainNameResolver domainNameResolver, LocalAddress localAddress, BoltProtocolVersion maxVersion, LoggingProvider logging, ValueFactory valueFactory, ObservationProvider observationProvider) {
        this.eventLoopGroup = eventLoopGroup;
        this.clock = Objects.requireNonNull(clock);
        this.domainNameResolver = Objects.requireNonNull(domainNameResolver);
        this.addressResolverGroup = new NettyDomainNameResolverGroup(this.domainNameResolver);
        this.localAddress = localAddress;
        this.maxVersion = maxVersion;
        this.logging = logging;
        this.valueFactory = Objects.requireNonNull(valueFactory);
        this.observationProvider = Objects.requireNonNull(observationProvider);
    }

    @Override
    public CompletionStage<Connection> acquireConnection(BoltServerAddress address, SecurityPlan securityPlan, RoutingContext routingContext, Map<String, Value> authMap, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, long initialisationTimeoutMillis, CompletableFuture<Long> latestAuthMillisFuture, NotificationConfig notificationConfig, ImmutableObservation parentObservation) {
        Object socketAddress;
        CompletableFuture<Duration> sslHandshakeFuture = new CompletableFuture<Duration>();
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.eventLoopGroup)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Math.max(connectTimeoutMillis, 0))).channel(this.localAddress != null ? LocalChannel.class : NioSocketChannel.class)).resolver(this.addressResolverGroup).handler((ChannelHandler)new NettyChannelInitializer(address, securityPlan, initialisationTimeoutMillis, this.clock, this.logging, sslHandshakeFuture));
        if (this.localAddress == null) {
            try {
                socketAddress = new InetSocketAddress(this.domainNameResolver.resolve(address.connectionHost())[0], address.port());
            }
            catch (Throwable t) {
                socketAddress = InetSocketAddress.createUnresolved(address.connectionHost(), address.port());
            }
        } else {
            socketAddress = this.localAddress;
        }
        return this.installChannelConnectedListener(address, bootstrap.connect((SocketAddress)socketAddress), initialisationTimeoutMillis, sslHandshakeFuture).thenCompose(channel -> {
            BoltProtocol boltProtocol = BoltProtocol.forChannel(channel);
            BoltExchangeObservation exchangeObservation = this.observationProvider.boltExchange(parentObservation, address.connectionHost(), address.port(), boltProtocol.version(), (k, v) -> {});
            return boltProtocol.initializeChannel((Channel)channel, Objects.requireNonNull(userAgent), Objects.requireNonNull(boltAgent), authMap, routingContext, notificationConfig, this.clock, latestAuthMillisFuture, this.valueFactory, exchangeObservation).whenComplete((ignored, throwable) -> {
                if (throwable != null) {
                    throwable = FutureUtil.completionExceptionCause(throwable);
                    exchangeObservation.error(throwable);
                }
                exchangeObservation.stop();
            });
        }).thenApply(channel -> new NetworkConnection((Channel)channel, this.logging));
    }

    private CompletionStage<Channel> installChannelConnectedListener(BoltServerAddress address, ChannelFuture channelConnected, long initialisationTimeoutMillis, CompletableFuture<Duration> sslHandshakeFuture) {
        ChannelPipeline pipeline = channelConnected.channel().pipeline();
        CompletableFuture<Channel> handshakeCompleted = new CompletableFuture<Channel>();
        channelConnected.addListener((GenericFutureListener)new ChannelConnectedListener(address, new ChannelPipelineBuilderImpl(), handshakeCompleted, this.maxVersion, this.logging, this.valueFactory, initialisationTimeoutMillis, sslHandshakeFuture));
        return handshakeCompleted;
    }
}

