/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.URI;
import java.time.Clock;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.neo4j.bolt.connection.AuthToken;
import org.neo4j.bolt.connection.BoltAgent;
import org.neo4j.bolt.connection.BoltConnection;
import org.neo4j.bolt.connection.BoltConnectionProvider;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.BoltServerAddress;
import org.neo4j.bolt.connection.DomainNameResolver;
import org.neo4j.bolt.connection.LoggingProvider;
import org.neo4j.bolt.connection.NotificationConfig;
import org.neo4j.bolt.connection.SecurityPlan;
import org.neo4j.bolt.connection.exception.BoltClientException;
import org.neo4j.bolt.connection.exception.MinVersionAcquisitionException;
import org.neo4j.bolt.connection.netty.impl.BoltConnectionImpl;
import org.neo4j.bolt.connection.netty.impl.ConnectionProvider;
import org.neo4j.bolt.connection.netty.impl.ConnectionProviders;
import org.neo4j.bolt.connection.netty.impl.NettyLogging;
import org.neo4j.bolt.connection.netty.impl.RoutingContext;
import org.neo4j.bolt.connection.netty.impl.Scheme;
import org.neo4j.bolt.connection.netty.impl.spi.Connection;
import org.neo4j.bolt.connection.netty.impl.util.FutureUtil;
import org.neo4j.bolt.connection.observation.ImmutableObservation;
import org.neo4j.bolt.connection.observation.ObservationProvider;
import org.neo4j.bolt.connection.values.ValueFactory;

public final class NettyBoltConnectionProvider
implements BoltConnectionProvider {
    private final LoggingProvider logging;
    private final System.Logger log;
    private final EventLoopGroup eventLoopGroup;
    private final ConnectionProvider connectionProvider;
    private final Clock clock;
    private final ValueFactory valueFactory;
    private final boolean shutdownEventLoopGroupOnClose;
    private final ObservationProvider observationProvider;
    private CompletableFuture<Void> closeFuture;

    public NettyBoltConnectionProvider(EventLoopGroup eventLoopGroup, Clock clock, DomainNameResolver domainNameResolver, LocalAddress localAddress, BoltProtocolVersion maxVersion, LoggingProvider logging, ValueFactory valueFactory, boolean shutdownEventLoopGroupOnClose, ObservationProvider observationProvider) {
        Objects.requireNonNull(eventLoopGroup);
        this.clock = Objects.requireNonNull(clock);
        this.logging = Objects.requireNonNull(logging);
        this.log = logging.getLog(this.getClass());
        this.eventLoopGroup = Objects.requireNonNull(eventLoopGroup);
        this.connectionProvider = ConnectionProviders.netty(eventLoopGroup, clock, domainNameResolver, localAddress, maxVersion, logging, valueFactory, observationProvider);
        this.valueFactory = Objects.requireNonNull(valueFactory);
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new NettyLogging(logging));
        this.shutdownEventLoopGroupOnClose = shutdownEventLoopGroupOnClose;
        this.observationProvider = Objects.requireNonNull(observationProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<BoltConnection> connect(URI uri, String routingContextAddress, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, SecurityPlan securityPlan, AuthToken authToken, BoltProtocolVersion minVersion, NotificationConfig notificationConfig, ImmutableObservation parentObservation) {
        RoutingContext routingContext;
        BoltServerAddress uriAddress;
        NettyBoltConnectionProvider nettyBoltConnectionProvider = this;
        synchronized (nettyBoltConnectionProvider) {
            if (this.closeFuture != null) {
                return CompletableFuture.failedFuture(new IllegalStateException("Connection provider is closed."));
            }
        }
        try {
            uriAddress = new BoltServerAddress(uri);
        }
        catch (Throwable throwable2) {
            return CompletableFuture.failedStage((Throwable)new BoltClientException("Failed to parse server address: " + String.valueOf(uri), throwable2));
        }
        BoltServerAddress address = securityPlan != null && securityPlan.expectedHostname() != null ? new BoltServerAddress(securityPlan.expectedHostname(), uriAddress.connectionHost(), uriAddress.port()) : uriAddress;
        try {
            routingContext = new RoutingContext(uri, routingContextAddress);
        }
        catch (Exception e) {
            return CompletableFuture.failedStage(e);
        }
        if (!Scheme.isRoutingScheme(uri.getScheme()) && routingContext.isDefined()) {
            return CompletableFuture.failedStage(new IllegalArgumentException("%s scheme must not contain routing context".formatted(uri.getScheme())));
        }
        CompletableFuture<Long> latestAuthMillisFuture = new CompletableFuture<Long>();
        return this.connectionProvider.acquireConnection(address, securityPlan, routingContext, authToken.asMap(), boltAgent, userAgent, connectTimeoutMillis, latestAuthMillisFuture, notificationConfig, parentObservation).thenCompose(connection -> {
            if (minVersion != null && minVersion.compareTo(connection.protocol().version()) > 0) {
                return connection.close().thenCompose(ignored -> CompletableFuture.failedStage((Throwable)new MinVersionAcquisitionException("lower version", connection.protocol().version())));
            }
            return CompletableFuture.completedStage(connection);
        }).handle((connection, throwable) -> {
            if (throwable != null) {
                throwable = FutureUtil.completionExceptionCause(throwable);
                this.log.log(System.Logger.Level.DEBUG, "Failed to establish BoltConnection " + String.valueOf(address), (Throwable)throwable);
                throw new CompletionException((Throwable)throwable);
            }
            return new BoltConnectionImpl(connection.protocol(), (Connection)connection, connection.eventLoop(), authToken, latestAuthMillisFuture, routingContext, this.clock, this.logging, this.valueFactory, this.observationProvider);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<Void> close() {
        CompletableFuture<Void> closeFuture;
        NettyBoltConnectionProvider nettyBoltConnectionProvider = this;
        synchronized (nettyBoltConnectionProvider) {
            if (this.closeFuture == null) {
                this.closeFuture = new CompletableFuture();
                if (this.shutdownEventLoopGroupOnClose) {
                    this.eventLoopGroup.shutdownGracefully(200L, 15000L, TimeUnit.MILLISECONDS).addListener(future -> this.closeFuture.complete(null));
                } else {
                    this.closeFuture.complete(null);
                }
            }
            closeFuture = this.closeFuture;
        }
        return closeFuture;
    }
}

