/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import java.time.Clock;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.neo4j.bolt.connection.BoltConnectionProvider;
import org.neo4j.bolt.connection.BoltConnectionProviderFactory;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.DefaultDomainNameResolver;
import org.neo4j.bolt.connection.DomainNameResolver;
import org.neo4j.bolt.connection.LoggingProvider;
import org.neo4j.bolt.connection.netty.impl.BootstrapFactory;
import org.neo4j.bolt.connection.netty.impl.NettyBoltConnectionProvider;
import org.neo4j.bolt.connection.observation.ObservationProvider;
import org.neo4j.bolt.connection.values.ValueFactory;

public final class NettyBoltConnectionProviderFactory
implements BoltConnectionProviderFactory {
    private static final Set<String> SUPPORTED_SCHEMES = Set.of("bolt", "bolt+s", "bolt+ssc", "neo4j", "neo4j+s", "neo4j+ssc");

    public boolean supports(String scheme) {
        return SUPPORTED_SCHEMES.contains(scheme);
    }

    public BoltConnectionProvider create(LoggingProvider loggingProvider, ValueFactory valueFactory, ObservationProvider observationProvider, Map<String, ?> additionalConfig) {
        System.Logger logger = loggingProvider.getLog(this.getClass());
        boolean shutdownEventLoopGroupOnClose = false;
        EventLoopGroup eventLoopGroup = NettyBoltConnectionProviderFactory.getConfigEntry(logger, additionalConfig, "eventLoopGroup", EventLoopGroup.class, () -> null);
        if (eventLoopGroup == null) {
            eventLoopGroup = this.createEventLoopGroup(logger, additionalConfig);
            shutdownEventLoopGroupOnClose = true;
        }
        Clock clock = NettyBoltConnectionProviderFactory.getConfigEntry(logger, additionalConfig, "clock", Clock.class, Clock::systemUTC);
        DomainNameResolver domainNameResolver = NettyBoltConnectionProviderFactory.getConfigEntry(logger, additionalConfig, "domainNameResolver", DomainNameResolver.class, DefaultDomainNameResolver::getInstance);
        LocalAddress localAddress = NettyBoltConnectionProviderFactory.getConfigEntry(logger, additionalConfig, "localAddress", LocalAddress.class, () -> null);
        BoltProtocolVersion maxVersion = NettyBoltConnectionProviderFactory.getConfigEntry(logger, additionalConfig, "maxVersion", BoltProtocolVersion.class, () -> null);
        return new NettyBoltConnectionProvider(eventLoopGroup, clock, domainNameResolver, localAddress, maxVersion, loggingProvider, valueFactory, shutdownEventLoopGroupOnClose, observationProvider);
    }

    private EventLoopGroup createEventLoopGroup(System.Logger logger, Map<String, ?> additionalConfig) {
        Integer size = NettyBoltConnectionProviderFactory.getConfigEntry(logger, additionalConfig, "eventLoopThreads", Integer.class, () -> 0);
        String eventLoopThreadNamePrefix = NettyBoltConnectionProviderFactory.getConfigEntry(logger, additionalConfig, "eventLoopThreadNamePrefix", String.class, () -> null);
        return BootstrapFactory.newBootstrap(size, eventLoopThreadNamePrefix).config().group();
    }

    private static <T> T getConfigEntry(System.Logger logger, Map<String, ?> config, String key, Class<T> type, Supplier<T> defaultValue) {
        Object value = config.get(key);
        if (value == null) {
            logger.log(System.Logger.Level.TRACE, "No %s provided, will use default", key);
            return defaultValue.get();
        }
        if (type.isAssignableFrom(value.getClass())) {
            logger.log(System.Logger.Level.TRACE, "Found %s provided", key);
            return type.cast(value);
        }
        logger.log(System.Logger.Level.ERROR, "Found %s provided, but it is not of type %s", key, type);
        throw new IllegalArgumentException("Expected " + String.valueOf(type) + " but got " + String.valueOf(value.getClass()));
    }
}

