/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.messaging.v57;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.bolt.connection.GqlError;
import org.neo4j.bolt.connection.exception.BoltProtocolException;
import org.neo4j.bolt.connection.netty.impl.messaging.ResponseMessageHandler;
import org.neo4j.bolt.connection.netty.impl.messaging.v5.MessageReaderV5;
import org.neo4j.bolt.connection.netty.impl.packstream.PackInput;
import org.neo4j.bolt.connection.values.Type;
import org.neo4j.bolt.connection.values.Value;
import org.neo4j.bolt.connection.values.ValueFactory;

public class MessageReaderV57
extends MessageReaderV5 {
    public MessageReaderV57(PackInput input, ValueFactory valueFactory) {
        super(input, valueFactory);
    }

    @Override
    protected void unpackFailureMessage(ResponseMessageHandler output) throws IOException {
        Map<String, Value> params = this.unpacker.unpackMap();
        GqlError gqlError = this.unpackGqlError(params);
        output.handleFailureMessage(gqlError);
    }

    protected GqlError unpackGqlError(Map<String, Value> params) {
        Map diagnosticRecord;
        String gqlStatus = params.get("gql_status").asString();
        String statusDescription = params.get("description").asString();
        String code = params.getOrDefault("neo4j_code", this.valueFactory.value("N/A")).asString();
        String message = params.get("message").asString();
        Value diagnosticRecordValue = params.get("diagnostic_record");
        if (diagnosticRecordValue != null && Type.MAP.equals((Object)diagnosticRecordValue.boltValueType())) {
            boolean containsOperation = diagnosticRecordValue.containsKey("OPERATION");
            boolean containsOperationCode = diagnosticRecordValue.containsKey("OPERATION_CODE");
            boolean containsCurrentSchema = diagnosticRecordValue.containsKey("CURRENT_SCHEMA");
            if (containsOperation && containsOperationCode && containsCurrentSchema) {
                diagnosticRecord = diagnosticRecordValue.asBoltMap();
            } else {
                diagnosticRecord = new HashMap(diagnosticRecordValue.asBoltMap());
                if (!containsOperation) {
                    diagnosticRecord.put("OPERATION", this.valueFactory.value(""));
                }
                if (!containsOperationCode) {
                    diagnosticRecord.put("OPERATION_CODE", this.valueFactory.value("0"));
                }
                if (!containsCurrentSchema) {
                    diagnosticRecord.put("CURRENT_SCHEMA", this.valueFactory.value("/"));
                }
                diagnosticRecord = Collections.unmodifiableMap(diagnosticRecord);
            }
        } else {
            diagnosticRecord = Map.ofEntries(Map.entry("OPERATION", this.valueFactory.value("")), Map.entry("OPERATION_CODE", this.valueFactory.value("0")), Map.entry("CURRENT_SCHEMA", this.valueFactory.value("/")));
        }
        GqlError gqlError = null;
        Value cause = params.get("cause");
        if (cause != null) {
            if (!Type.MAP.equals((Object)cause.boltValueType())) {
                throw new BoltProtocolException("Unexpected type");
            }
            gqlError = this.unpackGqlError(cause.asBoltMap());
        }
        return new GqlError(gqlStatus, statusDescription, code, message, diagnosticRecord, gqlError);
    }
}

