/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.messaging.common;

import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Map;
import org.neo4j.bolt.connection.netty.impl.messaging.ValuePacker;
import org.neo4j.bolt.connection.netty.impl.packstream.PackOutput;
import org.neo4j.bolt.connection.netty.impl.packstream.PackStream;
import org.neo4j.bolt.connection.values.IsoDuration;
import org.neo4j.bolt.connection.values.Point;
import org.neo4j.bolt.connection.values.Value;

public class CommonValuePacker
implements ValuePacker {
    public static final byte DATE = 68;
    public static final int DATE_STRUCT_SIZE = 1;
    public static final byte TIME = 84;
    public static final int TIME_STRUCT_SIZE = 2;
    public static final byte LOCAL_TIME = 116;
    public static final int LOCAL_TIME_STRUCT_SIZE = 1;
    public static final byte LOCAL_DATE_TIME = 100;
    public static final int LOCAL_DATE_TIME_STRUCT_SIZE = 2;
    public static final byte DATE_TIME_WITH_ZONE_OFFSET = 70;
    public static final byte DATE_TIME_WITH_ZONE_OFFSET_UTC = 73;
    public static final byte DATE_TIME_WITH_ZONE_ID = 102;
    public static final byte DATE_TIME_WITH_ZONE_ID_UTC = 105;
    public static final int DATE_TIME_STRUCT_SIZE = 3;
    public static final byte DURATION = 69;
    public static final int DURATION_TIME_STRUCT_SIZE = 4;
    public static final byte POINT_2D_STRUCT_TYPE = 88;
    public static final int POINT_2D_STRUCT_SIZE = 3;
    public static final byte POINT_3D_STRUCT_TYPE = 89;
    public static final int POINT_3D_STRUCT_SIZE = 4;
    private final boolean dateTimeUtcEnabled;
    protected final PackStream.Packer packer;

    public CommonValuePacker(PackOutput output, boolean dateTimeUtcEnabled) {
        this.dateTimeUtcEnabled = dateTimeUtcEnabled;
        this.packer = new PackStream.Packer(output);
    }

    @Override
    public final void packStructHeader(int size, byte signature) throws IOException {
        this.packer.packStructHeader(size, signature);
    }

    @Override
    public final void pack(String string) throws IOException {
        this.packer.pack(string);
    }

    @Override
    public final void pack(Value value) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException("Unable to pack: null");
        }
        this.packInternalValue(value);
    }

    @Override
    public final void pack(Map<String, Value> map) throws IOException {
        if (map == null || map.isEmpty()) {
            this.packer.packMapHeader(0);
            return;
        }
        this.packer.packMapHeader(map.size());
        for (Map.Entry<String, Value> entry : map.entrySet()) {
            this.packer.pack(entry.getKey());
            this.pack(entry.getValue());
        }
    }

    protected void packInternalValue(Value value) throws IOException {
        switch (value.boltValueType()) {
            case DATE: {
                this.packDate(value.asLocalDate());
                break;
            }
            case TIME: {
                this.packTime(value.asOffsetTime());
                break;
            }
            case LOCAL_TIME: {
                this.packLocalTime(value.asLocalTime());
                break;
            }
            case LOCAL_DATE_TIME: {
                this.packLocalDateTime(value.asLocalDateTime());
                break;
            }
            case DATE_TIME: {
                if (this.dateTimeUtcEnabled) {
                    this.packZonedDateTimeUsingUtcBaseline(value.asZonedDateTime());
                    break;
                }
                this.packZonedDateTime(value.asZonedDateTime());
                break;
            }
            case DURATION: {
                this.packDuration(value.asBoltIsoDuration());
                break;
            }
            case POINT: {
                this.packPoint(value.asBoltPoint());
                break;
            }
            case NULL: {
                this.packer.packNull();
                break;
            }
            case BYTES: {
                this.packer.pack(value.asByteArray());
                break;
            }
            case STRING: {
                this.packer.pack(value.asString());
                break;
            }
            case BOOLEAN: {
                this.packer.pack(value.asBoolean());
                break;
            }
            case INTEGER: {
                this.packer.pack(value.asLong());
                break;
            }
            case FLOAT: {
                this.packer.pack(value.asDouble());
                break;
            }
            case MAP: {
                this.packer.packMapHeader(value.size());
                for (String s : value.keys()) {
                    this.packer.pack(s);
                    this.pack(value.getBoltValue(s));
                }
                break;
            }
            case LIST: {
                this.packer.packListHeader(value.size());
                for (Value item : value.boltValues()) {
                    this.pack(item);
                }
                break;
            }
            default: {
                throw new IOException("Unknown type: " + value.boltValueType().name());
            }
        }
    }

    private void packDate(LocalDate localDate) throws IOException {
        this.packer.packStructHeader(1, (byte)68);
        this.packer.pack(localDate.toEpochDay());
    }

    private void packTime(OffsetTime offsetTime) throws IOException {
        long nanoOfDayLocal = offsetTime.toLocalTime().toNanoOfDay();
        int offsetSeconds = offsetTime.getOffset().getTotalSeconds();
        this.packer.packStructHeader(2, (byte)84);
        this.packer.pack(nanoOfDayLocal);
        this.packer.pack(offsetSeconds);
    }

    private void packLocalTime(LocalTime localTime) throws IOException {
        this.packer.packStructHeader(1, (byte)116);
        this.packer.pack(localTime.toNanoOfDay());
    }

    private void packLocalDateTime(LocalDateTime localDateTime) throws IOException {
        long epochSecondUtc = localDateTime.toEpochSecond(ZoneOffset.UTC);
        int nano = localDateTime.getNano();
        this.packer.packStructHeader(2, (byte)100);
        this.packer.pack(epochSecondUtc);
        this.packer.pack(nano);
    }

    private void packZonedDateTimeUsingUtcBaseline(ZonedDateTime zonedDateTime) throws IOException {
        Instant instant = zonedDateTime.toInstant();
        long epochSecondLocal = instant.getEpochSecond();
        int nano = zonedDateTime.getNano();
        ZoneId zone = zonedDateTime.getZone();
        if (zone instanceof ZoneOffset) {
            int offsetSeconds = ((ZoneOffset)zone).getTotalSeconds();
            this.packer.packStructHeader(3, (byte)73);
            this.packer.pack(epochSecondLocal);
            this.packer.pack(nano);
            this.packer.pack(offsetSeconds);
        } else {
            String zoneId = zone.getId();
            this.packer.packStructHeader(3, (byte)105);
            this.packer.pack(epochSecondLocal);
            this.packer.pack(nano);
            this.packer.pack(zoneId);
        }
    }

    private void packZonedDateTime(ZonedDateTime zonedDateTime) throws IOException {
        long epochSecondLocal = zonedDateTime.toLocalDateTime().toEpochSecond(ZoneOffset.UTC);
        int nano = zonedDateTime.getNano();
        ZoneId zone = zonedDateTime.getZone();
        if (zone instanceof ZoneOffset) {
            int offsetSeconds = ((ZoneOffset)zone).getTotalSeconds();
            this.packer.packStructHeader(3, (byte)70);
            this.packer.pack(epochSecondLocal);
            this.packer.pack(nano);
            this.packer.pack(offsetSeconds);
        } else {
            String zoneId = zone.getId();
            this.packer.packStructHeader(3, (byte)102);
            this.packer.pack(epochSecondLocal);
            this.packer.pack(nano);
            this.packer.pack(zoneId);
        }
    }

    private void packDuration(IsoDuration duration) throws IOException {
        this.packer.packStructHeader(4, (byte)69);
        this.packer.pack(duration.months());
        this.packer.pack(duration.days());
        this.packer.pack(duration.seconds());
        this.packer.pack(duration.nanoseconds());
    }

    private void packPoint(Point point) throws IOException {
        if (Double.isNaN(point.z())) {
            this.packPoint2D(point);
        } else {
            this.packPoint3D(point);
        }
    }

    private void packPoint2D(Point point) throws IOException {
        this.packer.packStructHeader(3, (byte)88);
        this.packer.pack(point.srid());
        this.packer.pack(point.x());
        this.packer.pack(point.y());
    }

    private void packPoint3D(Point point) throws IOException {
        this.packer.packStructHeader(4, (byte)89);
        this.packer.pack(point.srid());
        this.packer.pack(point.x());
        this.packer.pack(point.y());
        this.packer.pack(point.z());
    }
}

