/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Clock;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.bolt.connection.BoltAgent;
import org.neo4j.bolt.connection.BoltServerAddress;
import org.neo4j.bolt.connection.DomainNameResolver;
import org.neo4j.bolt.connection.LoggingProvider;
import org.neo4j.bolt.connection.MetricsListener;
import org.neo4j.bolt.connection.NotificationConfig;
import org.neo4j.bolt.connection.SecurityPlan;
import org.neo4j.bolt.connection.netty.impl.ConnectionProvider;
import org.neo4j.bolt.connection.netty.impl.RoutingContext;
import org.neo4j.bolt.connection.netty.impl.async.NetworkConnection;
import org.neo4j.bolt.connection.netty.impl.async.connection.ChannelConnectedListener;
import org.neo4j.bolt.connection.netty.impl.async.connection.ChannelPipelineBuilderImpl;
import org.neo4j.bolt.connection.netty.impl.async.connection.NettyChannelInitializer;
import org.neo4j.bolt.connection.netty.impl.async.connection.NettyDomainNameResolverGroup;
import org.neo4j.bolt.connection.netty.impl.async.inbound.ConnectTimeoutHandler;
import org.neo4j.bolt.connection.netty.impl.messaging.BoltProtocol;
import org.neo4j.bolt.connection.netty.impl.spi.Connection;
import org.neo4j.bolt.connection.values.Value;
import org.neo4j.bolt.connection.values.ValueFactory;

public final class NettyConnectionProvider
implements ConnectionProvider {
    private final EventLoopGroup eventLoopGroup;
    private final Clock clock;
    private final DomainNameResolver domainNameResolver;
    private final AddressResolverGroup<InetSocketAddress> addressResolverGroup;
    private final LocalAddress localAddress;
    private final LoggingProvider logging;
    private final ValueFactory valueFactory;

    public NettyConnectionProvider(EventLoopGroup eventLoopGroup, Clock clock, DomainNameResolver domainNameResolver, LocalAddress localAddress, LoggingProvider logging, ValueFactory valueFactory) {
        this.eventLoopGroup = eventLoopGroup;
        this.clock = Objects.requireNonNull(clock);
        this.domainNameResolver = Objects.requireNonNull(domainNameResolver);
        this.addressResolverGroup = new NettyDomainNameResolverGroup(this.domainNameResolver);
        this.localAddress = localAddress;
        this.logging = logging;
        this.valueFactory = Objects.requireNonNull(valueFactory);
    }

    @Override
    public CompletionStage<Connection> acquireConnection(BoltServerAddress address, SecurityPlan securityPlan, RoutingContext routingContext, Map<String, Value> authMap, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, CompletableFuture<Long> latestAuthMillisFuture, NotificationConfig notificationConfig, MetricsListener metricsListener) {
        Object socketAddress;
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.eventLoopGroup)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeoutMillis)).channel(this.localAddress != null ? LocalChannel.class : NioSocketChannel.class)).resolver(this.addressResolverGroup).handler((ChannelHandler)new NettyChannelInitializer(address, securityPlan, connectTimeoutMillis, this.clock, this.logging));
        if (this.localAddress == null) {
            try {
                socketAddress = new InetSocketAddress(this.domainNameResolver.resolve(address.connectionHost())[0], address.port());
            }
            catch (Throwable t) {
                socketAddress = InetSocketAddress.createUnresolved(address.connectionHost(), address.port());
            }
        } else {
            socketAddress = this.localAddress;
        }
        return this.installChannelConnectedListeners(address, bootstrap.connect((SocketAddress)socketAddress), connectTimeoutMillis).thenCompose(channel -> BoltProtocol.forChannel(channel).initializeChannel((Channel)channel, Objects.requireNonNull(userAgent), Objects.requireNonNull(boltAgent), authMap, routingContext, notificationConfig, this.clock, latestAuthMillisFuture, this.valueFactory)).thenApply(channel -> new NetworkConnection((Channel)channel, this.logging));
    }

    private CompletionStage<Channel> installChannelConnectedListeners(BoltServerAddress address, ChannelFuture channelConnected, int connectTimeoutMillis) {
        ChannelPipeline pipeline = channelConnected.channel().pipeline();
        channelConnected.addListener(future -> pipeline.addFirst(new ChannelHandler[]{new ConnectTimeoutHandler(connectTimeoutMillis)}));
        CompletableFuture<Channel> handshakeCompleted = new CompletableFuture<Channel>();
        channelConnected.addListener((GenericFutureListener)new ChannelConnectedListener(address, new ChannelPipelineBuilderImpl(), handshakeCompleted, this.logging, this.valueFactory));
        return handshakeCompleted.whenComplete((channel, throwable) -> {
            if (throwable == null) {
                channel.pipeline().remove(ConnectTimeoutHandler.class);
            }
        });
    }
}

