/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.handlers;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.neo4j.bolt.connection.netty.impl.spi.ResponseHandler;
import org.neo4j.bolt.connection.netty.impl.util.MetadataExtractor;
import org.neo4j.bolt.connection.summary.RunSummary;
import org.neo4j.bolt.connection.values.Value;

public class RunResponseHandler
implements ResponseHandler {
    private final CompletableFuture<RunSummary> runFuture;
    private final MetadataExtractor metadataExtractor;

    public RunResponseHandler(CompletableFuture<RunSummary> runFuture, MetadataExtractor metadataExtractor) {
        this.runFuture = runFuture;
        this.metadataExtractor = metadataExtractor;
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        List<String> queryKeys = this.metadataExtractor.extractQueryKeys(metadata);
        long resultAvailableAfter = this.metadataExtractor.extractResultAvailableAfter(metadata);
        long queryId = this.metadataExtractor.extractQueryId(metadata);
        Value db = metadata.get("db");
        String databaseName = db != null ? db.asString() : null;
        this.runFuture.complete(new RunResponseImpl(queryId, queryKeys, resultAvailableAfter, databaseName));
    }

    @Override
    public void onFailure(Throwable error) {
        this.runFuture.completeExceptionally(error);
    }

    @Override
    public void onRecord(Value[] fields) {
        throw new UnsupportedOperationException();
    }

    private record RunResponseImpl(long queryId, List<String> keys, long resultAvailableAfter, String database) implements RunSummary
    {
        public Optional<String> databaseName() {
            return Optional.ofNullable(this.database);
        }
    }
}

