/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.async.inbound;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.neo4j.bolt.connection.netty.impl.packstream.PackInput;

public class ByteBufInput
implements PackInput {
    private ByteBuf buf;

    public void start(ByteBuf newBuf) {
        this.assertNotStarted();
        this.buf = Objects.requireNonNull(newBuf);
    }

    public void stop() {
        this.buf = null;
    }

    @Override
    public byte readByte() {
        return this.buf.readByte();
    }

    @Override
    public short readShort() {
        return this.buf.readShort();
    }

    @Override
    public int readInt() {
        return this.buf.readInt();
    }

    @Override
    public long readLong() {
        return this.buf.readLong();
    }

    @Override
    public double readDouble() {
        return this.buf.readDouble();
    }

    @Override
    public void readBytes(byte[] into, int offset, int toRead) {
        this.buf.readBytes(into, offset, toRead);
    }

    @Override
    public byte peekByte() {
        return this.buf.getByte(this.buf.readerIndex());
    }

    private void assertNotStarted() {
        if (this.buf != null) {
            throw new IllegalStateException("Already started");
        }
    }
}

