/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.neo4j.bolt.connection.exception.BoltUntrustedServerException;
import org.neo4j.bolt.connection.values.Value;

public class MetadataExtractor {
    public static final int ABSENT_QUERY_ID = -1;
    private final String resultAvailableAfterMetadataKey;

    public MetadataExtractor(String resultAvailableAfterMetadataKey) {
        this.resultAvailableAfterMetadataKey = resultAvailableAfterMetadataKey;
    }

    public List<String> extractQueryKeys(Map<String, Value> metadata) {
        Value keysValue = metadata.get("fields");
        if (keysValue != null && !keysValue.isEmpty()) {
            ArrayList<String> keys = new ArrayList<String>(keysValue.size());
            for (Value value : keysValue.values()) {
                keys.add(value.asString());
            }
            return keys;
        }
        return Collections.emptyList();
    }

    public long extractQueryId(Map<String, Value> metadata) {
        Value queryId = metadata.get("qid");
        if (queryId != null) {
            return queryId.asLong();
        }
        return -1L;
    }

    public long extractResultAvailableAfter(Map<String, Value> metadata) {
        Value resultAvailableAfterValue = metadata.get(this.resultAvailableAfterMetadataKey);
        if (resultAvailableAfterValue != null) {
            return resultAvailableAfterValue.asLong();
        }
        return -1L;
    }

    public static Value extractServer(Map<String, Value> metadata) {
        Value versionValue = metadata.get("server");
        if (versionValue == null || versionValue.isNull()) {
            throw new BoltUntrustedServerException("Server provides no product identifier");
        }
        String serverAgent = versionValue.asString();
        if (!serverAgent.startsWith("Neo4j/")) {
            throw new BoltUntrustedServerException("Server does not identify as a genuine Neo4j instance: '" + serverAgent + "'");
        }
        return versionValue;
    }

    public static Set<String> extractBoltPatches(Map<String, Value> metadata) {
        Value boltPatch = metadata.get("patch_bolt");
        if (boltPatch != null && !boltPatch.isNull()) {
            return StreamSupport.stream(boltPatch.values().spliterator(), false).map(Value::asString).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }
}

