/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.entity;

import java.util.ArrayList;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.NotificationCategory;
import org.neo4j.graphdb.SeverityLevel;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;

public class HttpNotification
implements Notification {
    private final String code;
    private final String title;
    private final String description;
    private final SeverityLevel severity;
    private final InputPosition inputPosition;
    private final NotificationCategory category;

    private HttpNotification(String code, String title, String description, String severity, InputPosition inputPosition, String category) {
        this.code = code;
        this.title = title;
        this.description = description;
        this.severity = SeverityLevel.valueOf((String)severity);
        this.inputPosition = inputPosition;
        this.category = NotificationCategory.valueOf((String)category);
    }

    public static Iterable<Notification> iterableFromAnyValue(AnyValue anyValue) {
        if (anyValue == null) {
            return new ArrayList<Notification>();
        }
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        ListValue listValue = (ListValue)anyValue;
        listValue.forEach(listItem -> {
            MapValue mapValue = (MapValue)listItem;
            InputPosition inputPosition = InputPosition.empty;
            if (mapValue.containsKey("position")) {
                MapValue positionMap = (MapValue)mapValue.get("position");
                inputPosition = new InputPosition(((IntValue)positionMap.get("offset")).value(), ((IntValue)positionMap.get("line")).value(), ((IntValue)positionMap.get("column")).value());
            }
            notifications.add(new HttpNotification(((TextValue)mapValue.get("code")).stringValue(), ((TextValue)mapValue.get("title")).stringValue(), ((TextValue)mapValue.get("description")).stringValue(), ((TextValue)mapValue.get("severity")).stringValue(), inputPosition, mapValue.containsKey("category") ? ((TextValue)mapValue.get("category")).stringValue() : NotificationCategory.UNKNOWN.name()));
        });
        return notifications;
    }

    public String getCode() {
        return this.code;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public SeverityLevel getSeverity() {
        return this.severity;
    }

    public InputPosition getPosition() {
        return this.inputPosition;
    }

    public NotificationCategory getCategory() {
        return this.category;
    }
}

