/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import java.net.URI;
import java.time.Clock;
import java.time.Duration;
import java.util.Collections;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.protocol.common.connector.tx.TransactionOwner;
import org.neo4j.bolt.protocol.common.transaction.TransactionStateMachineSPIProvider;
import org.neo4j.bolt.protocol.common.transaction.statement.StatementProcessorProvider;
import org.neo4j.bolt.protocol.common.transaction.statement.StatementProcessorReleaseManager;
import org.neo4j.bolt.protocol.common.transaction.statement.metadata.StatementMetadata;
import org.neo4j.bolt.protocol.v41.message.request.RoutingContext;
import org.neo4j.bolt.protocol.v44.transaction.TransactionStateMachineSPIProviderV44;
import org.neo4j.bolt.transaction.CleanUpConnectionContext;
import org.neo4j.bolt.transaction.CleanUpTransactionContext;
import org.neo4j.bolt.transaction.InitializeContext;
import org.neo4j.bolt.transaction.TransactionManager;
import org.neo4j.bolt.transaction.TransactionNotFoundException;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.server.http.cypher.TransactionRegistry;
import org.neo4j.server.http.cypher.TransactionTerminationHandle;
import org.neo4j.server.http.cypher.format.api.Statement;
import org.neo4j.server.http.cypher.format.api.TransactionUriScheme;
import org.neo4j.time.SystemNanoClock;

public class TransactionHandle
implements TransactionTerminationHandle,
TransactionOwner {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(TransactionHandle.class);
    private final String databaseName;
    private final QueryExecutionEngine engine;
    private final TransactionRegistry registry;
    private final TransactionUriScheme uriScheme;
    private final TransactionManager transactionManager;
    private final KernelTransaction.Type type;
    private final Duration customTransactionTimeout;
    private final long id;
    private long expirationTimestamp = -1L;
    private final InternalLogProvider userLogProvider;
    private final BoltGraphDatabaseManagementServiceSPI boltSPI;
    private String txManagerTxId;
    private LoginContext loginContext;
    private final ClientConnectionInfo clientConnectionInfo;
    MemoryTracker memoryTracker;
    AuthManager authManager;
    private final SystemNanoClock clock;
    private final boolean readByDefault;

    TransactionHandle(String databaseName, QueryExecutionEngine engine, TransactionRegistry registry, TransactionUriScheme uriScheme, boolean implicitTransaction, LoginContext loginContext, ClientConnectionInfo clientConnectionInfo, long customTransactionTimeoutMillis, TransactionManager transactionManager, InternalLogProvider logProvider, BoltGraphDatabaseManagementServiceSPI boltSPI, MemoryTracker memoryTracker, AuthManager authManager, SystemNanoClock clock, boolean readByDefault) {
        this.databaseName = databaseName;
        this.engine = engine;
        this.registry = registry;
        this.uriScheme = uriScheme;
        this.type = implicitTransaction ? KernelTransaction.Type.IMPLICIT : KernelTransaction.Type.EXPLICIT;
        this.customTransactionTimeout = customTransactionTimeoutMillis != 0L ? Duration.ofMillis(customTransactionTimeoutMillis) : null;
        this.id = registry.begin(this);
        this.transactionManager = transactionManager;
        this.userLogProvider = logProvider;
        this.boltSPI = boltSPI;
        this.loginContext = loginContext;
        this.clientConnectionInfo = clientConnectionInfo;
        this.memoryTracker = memoryTracker;
        this.authManager = authManager;
        this.clock = clock;
        this.readByDefault = readByDefault;
        this.setUpStatementProcessor();
    }

    URI uri() {
        return this.uriScheme.txUri(this.id);
    }

    boolean isImplicit() {
        return this.type == KernelTransaction.Type.IMPLICIT;
    }

    long getExpirationTimestamp() {
        return this.expirationTimestamp;
    }

    long getId() {
        return this.id;
    }

    @Override
    public boolean terminate() {
        this.transactionManager.interrupt(this.txManagerTxId);
        return true;
    }

    void ensureActiveTransaction() throws KernelException {
        if (this.txManagerTxId == null) {
            this.beginTransaction();
        }
    }

    StatementMetadata executeStatement(Statement statement) throws KernelException, TransactionNotFoundException {
        return this.transactionManager.runQuery(this.txManagerTxId, statement.getStatement(), ValueUtils.asParameterMapValue(statement.getParameters()));
    }

    void forceRollback() throws TransactionNotFoundException {
        this.transactionManager.rollback(this.txManagerTxId);
        this.transactionManager.cleanUp(new CleanUpConnectionContext(Long.toString(this.id)));
    }

    void suspendTransaction() {
        this.expirationTimestamp = this.registry.release(this.id, this);
    }

    void commit() throws KernelException, TransactionNotFoundException {
        try {
            this.transactionManager.commit(this.txManagerTxId);
        }
        finally {
            this.registry.forget(this.id);
            this.transactionManager.cleanUp(new CleanUpConnectionContext(Long.toString(this.id)));
        }
    }

    void rollback() {
        try {
            this.transactionManager.rollback(this.txManagerTxId);
        }
        catch (TransactionNotFoundException transactionNotFoundException) {
        }
        finally {
            this.registry.forget(this.id);
            this.transactionManager.cleanUp(new CleanUpConnectionContext(Long.toString(this.id)));
        }
    }

    public LoginContext getLoginContext() {
        return this.loginContext;
    }

    boolean hasTransactionContext() {
        return this.txManagerTxId != null;
    }

    public MemoryTracker memoryTracker() {
        return this.memoryTracker;
    }

    public ClientConnectionInfo info() {
        return this.clientConnectionInfo;
    }

    public String selectedDefaultDatabase() {
        return this.databaseName;
    }

    private void setUpStatementProcessor() {
        TransactionStateMachineSPIProviderV44 transactionStateMachineSPIProvider = new TransactionStateMachineSPIProviderV44(this.boltSPI, (TransactionOwner)this, this.clock);
        HttpStatementProcessorReleaseManager statementProcessorReleaseManager = new HttpStatementProcessorReleaseManager(this.transactionManager);
        StatementProcessorProvider statementProcessorProvider = new StatementProcessorProvider((TransactionStateMachineSPIProvider)transactionStateMachineSPIProvider, (Clock)this.clock, (StatementProcessorReleaseManager)statementProcessorReleaseManager, new RoutingContext(true, Collections.emptyMap()), this.memoryTracker);
        this.transactionManager.initialize(new InitializeContext(Long.toString(this.getId()), statementProcessorProvider));
    }

    public void beginTransaction() throws KernelException {
        this.txManagerTxId = this.transactionManager.begin(this.loginContext, this.databaseName, Collections.emptyList(), this.readByDefault, Collections.emptyMap(), this.customTransactionTimeout, null, Long.toString(this.id));
    }

    public TransactionManager transactionManager() {
        return this.transactionManager;
    }

    public String getTxManagerTxId() {
        return this.txManagerTxId;
    }

    public static class HttpStatementProcessorReleaseManager
    implements StatementProcessorReleaseManager {
        private final TransactionManager transactionManager;

        public HttpStatementProcessorReleaseManager(TransactionManager transactionManager) {
            this.transactionManager = transactionManager;
        }

        public void releaseStatementProcessor(String transactionId) {
            this.transactionManager.cleanUp(new CleanUpTransactionContext(transactionId));
            this.transactionManager.cleanUp(new CleanUpConnectionContext(transactionId));
        }
    }
}

