/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.ArrayList;
import java.util.Iterator;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.internal.helpers.collection.IterableWrapper;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.ObjectRepresentation;
import org.neo4j.server.rest.repr.RelationshipRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;

public class PathRepresentation<P extends Path>
extends ObjectRepresentation {
    private final P path;

    public PathRepresentation(P path) {
        super(RepresentationType.PATH);
        this.path = path;
    }

    protected P getPath() {
        return this.path;
    }

    @ObjectRepresentation.Mapping(value="start")
    public ValueRepresentation startNode() {
        return ValueRepresentation.uri((String)NodeRepresentation.path(this.path.startNode()));
    }

    @ObjectRepresentation.Mapping(value="end")
    public ValueRepresentation endNode() {
        return ValueRepresentation.uri((String)NodeRepresentation.path(this.path.endNode()));
    }

    @ObjectRepresentation.Mapping(value="length")
    public ValueRepresentation length() {
        return ValueRepresentation.number((int)this.path.length());
    }

    @ObjectRepresentation.Mapping(value="nodes")
    public ListRepresentation nodes() {
        return new ListRepresentation(RepresentationType.NODE, (Iterable)new IterableWrapper<Representation, Node>(this.path.nodes()){

            protected Representation underlyingObjectToObject(Node node) {
                return ValueRepresentation.uri((String)NodeRepresentation.path(node));
            }
        });
    }

    @ObjectRepresentation.Mapping(value="relationships")
    public ListRepresentation relationships() {
        return new ListRepresentation(RepresentationType.RELATIONSHIP, (Iterable)new IterableWrapper<Representation, Relationship>(this.path.relationships()){

            protected Representation underlyingObjectToObject(Relationship node) {
                return ValueRepresentation.uri((String)RelationshipRepresentation.path(node));
            }
        });
    }

    @ObjectRepresentation.Mapping(value="directions")
    public ListRepresentation directions() {
        ArrayList<String> directionStrings = new ArrayList<String>();
        Iterator nodeIterator = this.path.nodes().iterator();
        Iterator relationshipIterator = this.path.relationships().iterator();
        Node endNode = (Node)nodeIterator.next();
        while (relationshipIterator.hasNext()) {
            Relationship rel = (Relationship)relationshipIterator.next();
            Node startNode = endNode;
            endNode = (Node)nodeIterator.next();
            if (rel.getStartNode().getElementId().equals(startNode.getElementId()) && rel.getEndNode().getElementId().equals(endNode.getElementId())) {
                directionStrings.add("->");
                continue;
            }
            directionStrings.add("<-");
        }
        return new ListRepresentation(RepresentationType.STRING, (Iterable)new IterableWrapper<Representation, String>(directionStrings){

            protected Representation underlyingObjectToObject(String directionString) {
                return ValueRepresentation.string((String)directionString);
            }
        });
    }
}

