/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.output.json;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.internal.helpers.collection.IterableWrapper;
import org.neo4j.server.http.cypher.entity.Predicates;
import org.neo4j.server.http.cypher.format.api.RecordEvent;
import org.neo4j.server.http.cypher.format.output.json.ResultDataContentWriter;

class GraphExtractionWriter
implements ResultDataContentWriter {
    GraphExtractionWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(JsonGenerator out, RecordEvent recordEvent) throws IOException {
        HashMap<Long, Node> nodesMap = new HashMap<Long, Node>();
        ArrayList<Relationship> relationshipList = new ArrayList<Relationship>();
        GraphExtractionWriter.extract(nodesMap, relationshipList, GraphExtractionWriter.map(recordEvent));
        HashSet<Node> nodes = new HashSet<Node>(nodesMap.values());
        HashSet<Relationship> relationships = new HashSet<Relationship>(relationshipList);
        out.writeObjectFieldStart("graph");
        try {
            GraphExtractionWriter.writeNodes(out, nodes);
            GraphExtractionWriter.writeRelationships(out, relationships);
        }
        finally {
            out.writeEndObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeNodes(JsonGenerator out, Iterable<Node> nodes) throws IOException {
        out.writeArrayFieldStart("nodes");
        try {
            for (Node node : nodes) {
                out.writeStartObject();
                try {
                    long nodeId = node.getId();
                    out.writeStringField("id", Long.toString(nodeId));
                    out.writeStringField("elementId", node.getElementId());
                    if (Predicates.isDeleted(node)) {
                        GraphExtractionWriter.markDeleted(out);
                        continue;
                    }
                    out.writeArrayFieldStart("labels");
                    try {
                        for (Label label : node.getLabels()) {
                            out.writeString(label.name());
                        }
                    }
                    finally {
                        out.writeEndArray();
                    }
                    GraphExtractionWriter.writeProperties(out, (Entity)node);
                }
                finally {
                    out.writeEndObject();
                }
            }
        }
        finally {
            out.writeEndArray();
        }
    }

    private static void markDeleted(JsonGenerator out) throws IOException {
        out.writeBooleanField("deleted", Boolean.TRUE.booleanValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRelationships(JsonGenerator out, Iterable<Relationship> relationships) throws IOException {
        out.writeArrayFieldStart("relationships");
        try {
            for (Relationship relationship : relationships) {
                out.writeStartObject();
                try {
                    long relationshipId = relationship.getId();
                    out.writeStringField("id", Long.toString(relationshipId));
                    out.writeStringField("elementId", relationship.getElementId());
                    if (Predicates.isDeleted(relationship)) {
                        GraphExtractionWriter.markDeleted(out);
                        continue;
                    }
                    out.writeStringField("type", relationship.getType().name());
                    out.writeStringField("startNode", Long.toString(relationship.getStartNodeId()));
                    out.writeStringField("startNodeElementId", relationship.getStartNode().getElementId());
                    out.writeStringField("endNode", Long.toString(relationship.getEndNodeId()));
                    out.writeStringField("endNodeElementId", relationship.getEndNode().getElementId());
                    GraphExtractionWriter.writeProperties(out, (Entity)relationship);
                }
                finally {
                    out.writeEndObject();
                }
            }
        }
        finally {
            out.writeEndArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeProperties(JsonGenerator out, Entity container) throws IOException {
        out.writeObjectFieldStart("properties");
        try {
            for (Map.Entry property : container.getAllProperties().entrySet()) {
                out.writeObjectField((String)property.getKey(), property.getValue());
            }
        }
        finally {
            out.writeEndObject();
        }
    }

    private static void extract(Map<Long, Node> nodes, ArrayList<Relationship> relationships, Iterable<?> source) throws IOException {
        for (Object item : source) {
            if (item instanceof Node) {
                Node node = (Node)item;
                GraphExtractionWriter.addNode(nodes, node.getId(), () -> node);
            } else if (item instanceof Relationship) {
                Relationship relationship = (Relationship)item;
                relationships.add(relationship);
                GraphExtractionWriter.addNode(nodes, relationship.getStartNodeId(), () -> ((Relationship)relationship).getStartNode());
                GraphExtractionWriter.addNode(nodes, relationship.getEndNodeId(), () -> ((Relationship)relationship).getEndNode());
            }
            if (item instanceof Path) {
                Path path = (Path)item;
                for (Node node : path.nodes()) {
                    GraphExtractionWriter.addNode(nodes, node.getId(), () -> node);
                }
                for (Relationship relationship : path.relationships()) {
                    relationships.add(relationship);
                }
                continue;
            }
            if (item instanceof Map) {
                GraphExtractionWriter.extract(nodes, relationships, ((Map)item).values());
                continue;
            }
            if (!(item instanceof Iterable)) continue;
            GraphExtractionWriter.extract(nodes, relationships, (Iterable)item);
        }
    }

    private static void addNode(Map<Long, Node> nodes, Long id, Supplier<Node> nodeSupplier) throws IOException {
        if (nodes.containsKey(id)) {
            Node existingNode = nodes.get(id);
            if (!Predicates.isDeleted(existingNode) && !Predicates.isFullNode(existingNode)) {
                nodes.remove(id);
                nodes.put(id, nodeSupplier.get());
            }
        } else {
            nodes.put(id, nodeSupplier.get());
        }
    }

    private static Iterable<?> map(final RecordEvent recordEvent) {
        return new IterableWrapper<Object, String>(recordEvent.getColumns()){

            protected Object underlyingObjectToObject(String key) {
                return recordEvent.getValue(key);
            }
        };
    }
}

