/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.kernel.impl.util.BaseToObjectValueWriter;
import org.neo4j.server.http.cypher.entity.HttpNode;
import org.neo4j.server.http.cypher.entity.HttpPath;
import org.neo4j.server.http.cypher.entity.HttpRelationship;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;

public class CachingWriter
extends BaseToObjectValueWriter<IOException> {
    private Object cachedObject;
    private ValueMapper mapper;
    private BiFunction<Long, Boolean, Optional<Node>> getNodeById;

    public CachingWriter(ValueMapper mapper) {
        this.mapper = mapper;
        this.getNodeById = (ignoredA, ignoredB) -> Optional.empty();
    }

    public Object getCachedObject() {
        return this.cachedObject;
    }

    public void writeRelationship(String elementId, long relId, String startNodeElementId, long startNodeId, String endNodeElementId, long endNodeId, TextValue type, MapValue properties, boolean isDeleted) {
        this.cachedObject = new HttpRelationship(elementId, relId, startNodeElementId, startNodeId, endNodeElementId, endNodeId, type.stringValue(), this.processProperties(properties), isDeleted, this.getNodeById);
    }

    public void writePath(NodeValue[] nodes, RelationshipValue[] relationships) {
        List<Node> nodeList = this.convertNodeValues(nodes);
        List<Relationship> relList = this.convertRelationshipValues(relationships);
        this.cachedObject = new HttpPath(nodeList, relList);
    }

    public void writeNode(String elementId, long nodeId, TextArray labels, MapValue properties, boolean isDeleted) {
        List<Label> labelList = Arrays.stream((String[])labels.asObjectCopy()).map(Label::label).collect(Collectors.toList());
        this.cachedObject = new HttpNode(elementId, nodeId, labelList, this.processProperties(properties), isDeleted);
    }

    protected Node newNodeEntityById(long id) {
        throw new UnsupportedOperationException("Only can write existing nodes");
    }

    protected Node newNodeEntityByElementId(String elementId) {
        throw new UnsupportedOperationException("Only can write existing nodes");
    }

    protected Relationship newRelationshipEntityById(long id) {
        throw new UnsupportedOperationException("Only can write existing relationships");
    }

    protected Relationship newRelationshipEntityByElementId(String elementId) {
        throw new UnsupportedOperationException("Only can write existing relationships");
    }

    protected Point newPoint(CoordinateReferenceSystem crs, double[] coordinate) {
        throw new UnsupportedOperationException("Does not write points");
    }

    public void setGetNodeById(BiFunction<Long, Boolean, Optional<Node>> getNodeById) {
        this.getNodeById = getNodeById;
    }

    private Map<String, Object> processProperties(MapValue properties) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        properties.foreach((k, v) -> propertyMap.put((String)k, v.map(this.mapper)));
        return propertyMap;
    }

    private List<Node> convertNodeValues(NodeValue[] nodeValues) {
        ArrayList<Node> nodeArrayList = new ArrayList<Node>();
        for (NodeValue nodeValue : nodeValues) {
            this.writeNode(nodeValue.elementId(), nodeValue.id(), nodeValue.labels(), nodeValue.properties(), nodeValue.isDeleted());
            nodeArrayList.add((HttpNode)this.cachedObject);
        }
        return nodeArrayList;
    }

    private List<Relationship> convertRelationshipValues(RelationshipValue[] relationships) {
        ArrayList<Relationship> relArrayList = new ArrayList<Relationship>();
        for (RelationshipValue relationship : relationships) {
            this.writeRelationship(relationship.elementId(), relationship.id(), relationship.startNodeElementId(), relationship.startNodeId(), relationship.endNodeElementId(), relationship.endNodeId(), relationship.type(), relationship.properties(), relationship.isDeleted());
            relArrayList.add((HttpRelationship)this.cachedObject);
        }
        return relArrayList;
    }
}

