/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.ssl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.server.configuration.ConfigurableTransports;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.security.ssl.HttpsRequestCustomizer;
import org.neo4j.server.web.HttpConnectorFactory;
import org.neo4j.server.web.JettyHttp2ConnectionListener;
import org.neo4j.server.web.JettyHttpConnectionFactory;
import org.neo4j.server.web.JettyThreadCalculator;
import org.neo4j.ssl.SslPolicy;

public class SslSocketConnectorFactory
extends HttpConnectorFactory {
    private static final String HTTPS_NAME = "https";
    private static final String HTTPS2_NAME = "https2";
    private final HttpConfiguration.Customizer requestCustomizer;

    public SslSocketConnectorFactory(NetworkConnectionTracker connectionTracker, Config config, ByteBufferPool byteBufferPool) {
        super(HTTPS_NAME, connectionTracker, config, byteBufferPool);
        this.requestCustomizer = new HttpsRequestCustomizer(config);
    }

    @Override
    protected HttpConfiguration createHttpConfig(boolean requiresHostnameVerification) {
        HttpConfiguration httpConfig = super.createHttpConfig(requiresHostnameVerification);
        httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer(requiresHostnameVerification));
        httpConfig.addCustomizer(this.requestCustomizer);
        return httpConfig;
    }

    public ServerConnector createConnector(Server server, SslPolicy sslPolicy, SocketAddress address, JettyThreadCalculator jettyThreadCalculator) {
        HttpConfiguration httpConfig = this.createHttpConfig(sslPolicy.isVerifyHostname());
        ArrayList<ConnectionFactory> connectionFactories = new ArrayList<ConnectionFactory>();
        JettyHttpConnectionFactory http11 = new JettyHttpConnectionFactory(this.connectionTracker, httpConfig);
        if (((Set)this.configuration.get(ServerSettings.http_enabled_transports)).contains((Object)ConfigurableTransports.HTTP2)) {
            JettyHttp2ConnectionListener httpsConnectionListener = new JettyHttp2ConnectionListener(this.connectionTracker, HTTPS2_NAME);
            HTTP2ServerConnectionFactory http2 = new HTTP2ServerConnectionFactory(httpConfig);
            http2.addBean((Object)httpsConnectionListener);
            ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
            SslConnectionFactory sslConnectionFactory = SslSocketConnectorFactory.createSslConnectionFactory(sslPolicy, alpn.getProtocol());
            connectionFactories.add((ConnectionFactory)sslConnectionFactory);
            connectionFactories.add((ConnectionFactory)alpn);
            connectionFactories.add((ConnectionFactory)http2);
            if (((Set)this.configuration.get(ServerSettings.http_enabled_transports)).contains((Object)ConfigurableTransports.HTTP1_1)) {
                alpn.setDefaultProtocol(http11.getProtocol());
                connectionFactories.add((ConnectionFactory)http11);
            }
        } else if (((Set)this.configuration.get(ServerSettings.http_enabled_transports)).equals(Set.of(ConfigurableTransports.HTTP1_1))) {
            SslConnectionFactory sslConnectionFactory = SslSocketConnectorFactory.createSslConnectionFactory(sslPolicy, http11.getProtocol());
            connectionFactories.add((ConnectionFactory)sslConnectionFactory);
            connectionFactories.add((ConnectionFactory)http11);
        }
        return this.createConnector(server, address, jettyThreadCalculator, connectionFactories);
    }

    private static SslConnectionFactory createSslConnectionFactory(SslPolicy sslPolicy, String nextProtocol) {
        String[] protocols;
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        String password = UUID.randomUUID().toString();
        sslContextFactory.setKeyStore(sslPolicy.getKeyStore(password.toCharArray(), password.toCharArray()));
        sslContextFactory.setKeyStorePassword(password);
        sslContextFactory.setKeyManagerPassword(password);
        List ciphers = sslPolicy.getCipherSuites();
        if (ciphers != null) {
            sslContextFactory.setIncludeCipherSuites(ciphers.toArray(new String[0]));
            sslContextFactory.setExcludeCipherSuites(new String[0]);
        }
        if ((protocols = sslPolicy.getTlsVersions()) != null) {
            sslContextFactory.setIncludeProtocols(protocols);
            sslContextFactory.setExcludeProtocols(new String[0]);
        }
        switch (sslPolicy.getClientAuth()) {
            case REQUIRE: {
                sslContextFactory.setNeedClientAuth(true);
                break;
            }
            case OPTIONAL: {
                sslContextFactory.setWantClientAuth(true);
                break;
            }
            case NONE: {
                sslContextFactory.setWantClientAuth(false);
                sslContextFactory.setNeedClientAuth(false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not supported: " + String.valueOf(sslPolicy.getClientAuth()));
            }
        }
        return new SslConnectionFactory(sslContextFactory, nextProtocol);
    }
}

