/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.queryapi.request;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.neo4j.server.queryapi.request.DefaultRequestModule;
import org.neo4j.server.queryapi.request.QueryRequest;

@Provider
@Consumes(value={"application/vnd.neo4j.query"})
public class TypedJsonMessageBodyReader
implements MessageBodyReader<QueryRequest> {
    private final JsonMapper jsonMapper = (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new DefaultRequestModule())).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).build();

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.isAssignableFrom(QueryRequest.class);
    }

    public QueryRequest readFrom(Class<QueryRequest> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        if (entityStream.available() == 0) {
            return new QueryRequest();
        }
        try {
            return (QueryRequest)this.jsonMapper.readValue(entityStream, QueryRequest.class);
        }
        catch (JacksonException e) {
            throw new BadRequestException();
        }
    }
}

