/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.impl.util.DefaultValueMapper;
import org.neo4j.server.http.cypher.CachingWriter;
import org.neo4j.server.http.cypher.entity.HttpNode;
import org.neo4j.server.http.cypher.entity.HttpPath;
import org.neo4j.server.http.cypher.entity.HttpRelationship;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public class TransactionIndependentValueMapper
extends DefaultValueMapper {
    private final CachingWriter cachingWriter;

    public TransactionIndependentValueMapper(CachingWriter cachingWriter) {
        super(null);
        this.cachingWriter = cachingWriter;
    }

    public Object mapMap(MapValue value) {
        HashMap map = new HashMap();
        value.foreach((k, v) -> {
            if (v instanceof NodeValue || v instanceof RelationshipValue) {
                try {
                    v.writeTo((AnyValueWriter)this.cachingWriter);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                map.put(k, this.cachingWriter.getCachedObject());
            } else {
                map.put(k, v.map((ValueMapper)this));
            }
        });
        return map;
    }

    public List<?> mapSequence(SequenceValue value) {
        ArrayList list = new ArrayList(value.intSize());
        value.forEach(v -> {
            if (v instanceof NodeValue || v instanceof RelationshipValue) {
                try {
                    v.writeTo((AnyValueWriter)this.cachingWriter);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                list.add(this.cachingWriter.getCachedObject());
            } else {
                list.add(v.map((ValueMapper)this));
            }
        });
        return list;
    }

    public Node mapNode(VirtualNodeValue value) {
        try {
            value.writeTo((AnyValueWriter)this.cachingWriter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (HttpNode)this.cachingWriter.getCachedObject();
    }

    public Relationship mapRelationship(VirtualRelationshipValue value) {
        try {
            value.writeTo((AnyValueWriter)this.cachingWriter);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return (HttpRelationship)this.cachingWriter.getCachedObject();
    }

    public Path mapPath(VirtualPathValue value) {
        try {
            value.writeTo((AnyValueWriter)this.cachingWriter);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return (HttpPath)this.cachingWriter.getCachedObject();
    }
}

