/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import org.neo4j.kernel.api.exceptions.Status;

public class Neo4jError {
    private final Status status;
    private final Throwable cause;

    public Neo4jError(Status status, String message) {
        this(status, new RuntimeException(message));
    }

    public Neo4jError(Status status, Throwable cause) {
        if (status == null) {
            throw new IllegalArgumentException("statusCode must not be null");
        }
        if (cause == null) {
            throw new IllegalArgumentException("cause must not be null");
        }
        this.status = status;
        this.cause = cause;
    }

    public String toString() {
        return String.format("%s[%s, cause=\"%s\"]", this.getClass().getSimpleName(), this.status.code(), this.cause);
    }

    public Throwable cause() {
        return this.cause;
    }

    public Status status() {
        return this.status;
    }

    public String getMessage() {
        return this.cause.getMessage();
    }
}

