/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.MovedContextHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.connectors.CommonConnectorConfig;
import org.neo4j.configuration.helpers.PortBindException;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.server.bind.ComponentsBinder;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.security.ssl.SslSocketConnectorFactory;
import org.neo4j.server.web.HttpChannelOptionalRequestLogHandler;
import org.neo4j.server.web.HttpConnectorFactory;
import org.neo4j.server.web.Injectable;
import org.neo4j.server.web.JaxRsServletHolderFactory;
import org.neo4j.server.web.JettyThreadCalculator;
import org.neo4j.server.web.NeoJettyErrorHandler;
import org.neo4j.server.web.StaticContentFilter;
import org.neo4j.server.web.WebContainerThreadInfo;
import org.neo4j.server.web.WebServer;
import org.neo4j.ssl.SslPolicy;

public class JettyWebServer
implements WebServer,
WebContainerThreadInfo {
    private static final int JETTY_THREAD_POOL_IDLE_TIMEOUT = 60000;
    public static final SocketAddress DEFAULT_ADDRESS = new SocketAddress("0.0.0.0", 80);
    private boolean wadlEnabled;
    private ComponentsBinder binder;
    private RequestLog requestLog;
    private Server jetty;
    private HandlerCollection handlers;
    private SocketAddress httpAddress = DEFAULT_ADDRESS;
    private SocketAddress httpsAddress;
    private ServerConnector httpConnector;
    private ServerConnector httpsConnector;
    private final Map<String, String> staticContent = new HashMap<String, String>();
    private final Map<String, JaxRsServletHolderFactory> jaxRsServletHolderFactories = new HashMap<String, JaxRsServletHolderFactory>();
    private final List<FilterDefinition> filters = new ArrayList<FilterDefinition>();
    private int jettyMaxThreads = 1;
    private SslPolicy sslPolicy;
    private final boolean ocspStaplingEnabled;
    private final String contentSecurityPolicyHeader;
    private final SslSocketConnectorFactory sslSocketFactory;
    private final HttpConnectorFactory connectorFactory;
    private final InternalLog log;

    public JettyWebServer(InternalLogProvider logProvider, Config config, NetworkConnectionTracker connectionTracker, ByteBufferPool byteBufferPool) {
        this.log = logProvider.getLog(this.getClass());
        this.ocspStaplingEnabled = (Boolean)config.get(CommonConnectorConfig.ocsp_stapling_enabled);
        this.contentSecurityPolicyHeader = (String)config.get(ServerSettings.http_static_content_security_policy);
        this.sslSocketFactory = new SslSocketConnectorFactory(connectionTracker, config, byteBufferPool);
        this.connectorFactory = new HttpConnectorFactory(connectionTracker, config, byteBufferPool);
    }

    @Override
    public void start() throws Exception {
        if (this.jetty == null) {
            this.verifyAddressConfiguration();
            JettyThreadCalculator jettyThreadCalculator = new JettyThreadCalculator(this.jettyMaxThreads);
            this.jetty = new Server((ThreadPool)JettyWebServer.createQueuedThreadPool(jettyThreadCalculator));
            if (this.httpAddress != null) {
                this.httpConnector = this.connectorFactory.createConnector(this.jetty, this.httpAddress, jettyThreadCalculator);
                this.jetty.addConnector((Connector)this.httpConnector);
            }
            if (this.httpsAddress != null) {
                if (this.sslPolicy == null) {
                    throw new RuntimeException("HTTPS set to enabled, but no SSL policy provided");
                }
                if (this.ocspStaplingEnabled) {
                    System.setProperty("jdk.tls.server.enableStatusRequestExtension", "true");
                }
                this.httpsConnector = this.sslSocketFactory.createConnector(this.jetty, this.sslPolicy, this.httpsAddress, jettyThreadCalculator);
                this.jetty.addConnector((Connector)this.httpsConnector);
            }
        }
        this.handlers = new HandlerList();
        this.jetty.setHandler((Handler)this.handlers);
        this.handlers.addHandler((Handler)new MovedContextHandler());
        this.loadAllMounts();
        if (this.requestLog != null) {
            this.loadRequestLogging();
        }
        this.startJetty();
    }

    private static QueuedThreadPool createQueuedThreadPool(JettyThreadCalculator jtc) {
        BlockingArrayQueue queue = new BlockingArrayQueue(jtc.getMinThreads(), jtc.getMinThreads(), jtc.getMaxCapacity());
        QueuedThreadPool threadPool = new QueuedThreadPool(jtc.getMaxThreads(), jtc.getMinThreads(), 60000, (BlockingQueue)queue);
        threadPool.setThreadPoolBudget(null);
        return threadPool;
    }

    @Override
    public void stop() {
        if (this.jetty != null) {
            try {
                this.jetty.stop();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                this.jetty.join();
            }
            catch (InterruptedException e) {
                this.log.warn("Interrupted while waiting for Jetty to stop");
            }
            this.jetty = null;
        }
    }

    @Override
    public void setHttpAddress(SocketAddress address) {
        this.httpAddress = address;
    }

    @Override
    public void setHttpsAddress(SocketAddress address) {
        this.httpsAddress = address;
    }

    @Override
    public void setSslPolicy(SslPolicy policy) {
        this.sslPolicy = policy;
    }

    @Override
    public void setMaxThreads(int maxThreads) {
        this.jettyMaxThreads = maxThreads;
    }

    @Override
    public void addJAXRSPackages(List<String> packageNames, String mountPoint, Collection<Injectable<?>> injectables) {
        mountPoint = this.ensureRelativeUri(mountPoint);
        mountPoint = JettyWebServer.trimTrailingSlashToKeepJettyHappy(mountPoint);
        JaxRsServletHolderFactory factory = this.jaxRsServletHolderFactories.computeIfAbsent(mountPoint, k -> new JaxRsServletHolderFactory());
        factory.addPackages(packageNames, injectables);
        this.log.debug("Adding JAXRS packages %s at [%s]", new Object[]{packageNames, mountPoint});
    }

    @Override
    public void addJAXRSClasses(List<Class<?>> classNames, String mountPoint, Collection<Injectable<?>> injectables) {
        mountPoint = this.ensureRelativeUri(mountPoint);
        mountPoint = JettyWebServer.trimTrailingSlashToKeepJettyHappy(mountPoint);
        JaxRsServletHolderFactory factory = this.jaxRsServletHolderFactories.computeIfAbsent(mountPoint, k -> new JaxRsServletHolderFactory());
        factory.addClasses(classNames, injectables);
        this.log.debug("Adding JAXRS classes %s at [%s]", new Object[]{classNames, mountPoint});
    }

    @Override
    public void setWadlEnabled(boolean wadlEnabled) {
        this.wadlEnabled = wadlEnabled;
    }

    @Override
    public void setComponentsBinder(ComponentsBinder binder) {
        this.binder = binder;
    }

    @Override
    public void removeJAXRSPackages(List<String> packageNames, String serverMountPoint) {
        JaxRsServletHolderFactory factory = this.jaxRsServletHolderFactories.get(serverMountPoint);
        if (factory != null) {
            factory.removePackages(packageNames);
        }
    }

    @Override
    public void removeJAXRSClasses(List<Class<?>> classNames, String serverMountPoint) {
        JaxRsServletHolderFactory factory = this.jaxRsServletHolderFactories.get(serverMountPoint);
        if (factory != null) {
            factory.removeClasses(classNames);
        }
    }

    @Override
    public void addFilter(Filter filter, String pathSpec) {
        this.filters.add(new FilterDefinition(filter, pathSpec));
    }

    @Override
    public void removeFilter(Filter filter, String pathSpec) {
        this.filters.removeIf(current -> current.matches(filter, pathSpec));
    }

    @Override
    public void addStaticContent(String contentLocation, String serverMountPoint) {
        this.staticContent.put(serverMountPoint, contentLocation);
    }

    @Override
    public void removeStaticContent(String contentLocation, String serverMountPoint) {
        this.staticContent.remove(serverMountPoint);
    }

    @Override
    public void setRequestLog(RequestLog requestLog) {
        this.requestLog = requestLog;
    }

    public Server getJetty() {
        return this.jetty;
    }

    private void startJetty() throws Exception {
        try {
            this.jetty.start();
        }
        catch (IOException e) {
            throw new PortBindException(this.httpAddress, this.httpsAddress, (Throwable)e);
        }
    }

    @Override
    public InetSocketAddress getLocalHttpAddress() {
        return JettyWebServer.getAddress("HTTP", this.httpConnector);
    }

    @Override
    public InetSocketAddress getLocalHttpsAddress() {
        return JettyWebServer.getAddress("HTTPS", this.httpsConnector);
    }

    private void loadAllMounts() {
        TreeSet mountpoints = new TreeSet(Comparator.reverseOrder());
        mountpoints.addAll(this.staticContent.keySet());
        mountpoints.addAll(this.jaxRsServletHolderFactories.keySet());
        for (String contentKey : mountpoints) {
            boolean isStatic = this.staticContent.containsKey(contentKey);
            boolean isJaxRs = this.jaxRsServletHolderFactories.containsKey(contentKey);
            if (isStatic && isJaxRs) {
                throw new RuntimeException(String.format("content-key '%s' is mapped more than once", contentKey));
            }
            if (isStatic) {
                this.loadStaticContent(contentKey);
                continue;
            }
            if (isJaxRs) {
                this.loadJaxRsResource(contentKey);
                continue;
            }
            throw new RuntimeException(String.format("content-key '%s' is not mapped", contentKey));
        }
    }

    private void loadRequestLogging() {
        HttpChannelOptionalRequestLogHandler requestLogHandler = new HttpChannelOptionalRequestLogHandler();
        requestLogHandler.setRequestLog(this.requestLog);
        requestLogHandler.setServer(this.jetty);
        requestLogHandler.setHandler(this.jetty.getHandler());
        this.jetty.setHandler((Handler)requestLogHandler);
    }

    private static String trimTrailingSlashToKeepJettyHappy(String mountPoint) {
        if (mountPoint.equals("/")) {
            return mountPoint;
        }
        if (mountPoint.endsWith("/")) {
            mountPoint = mountPoint.substring(0, mountPoint.length() - 1);
        }
        return mountPoint;
    }

    private String ensureRelativeUri(String mountPoint) {
        try {
            URI result = new URI(mountPoint);
            if (result.isAbsolute()) {
                return result.getPath();
            }
            return result.toString();
        }
        catch (URISyntaxException e) {
            this.log.debug("Unable to translate [%s] to a relative URI in ensureRelativeUri(String mountPoint)", new Object[]{mountPoint});
            return mountPoint;
        }
    }

    private void loadStaticContent(String mountPoint) {
        String contentLocation = this.staticContent.get(mountPoint);
        try {
            SessionHandler sessionHandler = new SessionHandler();
            sessionHandler.setServer(this.getJetty());
            WebAppContext staticContext = new WebAppContext();
            staticContext.setServer(this.getJetty());
            staticContext.setContextPath(mountPoint);
            staticContext.setSessionHandler(sessionHandler);
            staticContext.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
            URL resourceLoc = this.getClass().getClassLoader().getResource(contentLocation);
            if (resourceLoc != null) {
                URL url = resourceLoc.toURI().toURL();
                Resource resource = Resource.newResource((URL)url);
                staticContext.setBaseResource(resource);
                this.addFiltersTo((ServletContextHandler)staticContext);
                staticContext.addFilter(new FilterHolder((Filter)new StaticContentFilter(this.contentSecurityPolicyHeader)), "/*", EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD));
                this.handlers.addHandler((Handler)staticContext);
            }
        }
        catch (Exception e) {
            this.log.error("Unknown error loading static content", (Throwable)e);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void loadJaxRsResource(String mountPoint) {
        this.log.debug("Mounting servlet at [%s]", new Object[]{mountPoint});
        SessionHandler sessionHandler = new SessionHandler();
        sessionHandler.setServer(this.getJetty());
        JaxRsServletHolderFactory jaxRsServletHolderFactory = this.jaxRsServletHolderFactories.get(mountPoint);
        ServletContextHandler jerseyContext = new ServletContextHandler();
        jerseyContext.setServer(this.getJetty());
        jerseyContext.setErrorHandler((ErrorHandler)new NeoJettyErrorHandler());
        jerseyContext.setContextPath(mountPoint);
        jerseyContext.setSessionHandler(sessionHandler);
        jerseyContext.addServlet(jaxRsServletHolderFactory.create(this.binder, this.wadlEnabled), "/*");
        this.addFiltersTo(jerseyContext);
        this.handlers.addHandler((Handler)jerseyContext);
    }

    private void addFiltersTo(ServletContextHandler context) {
        for (FilterDefinition filterDef : this.filters) {
            if (context.getContextPath().equals("/")) {
                context.addFilter(new FilterHolder(filterDef.getFilter()), "/", EnumSet.allOf(DispatcherType.class));
                continue;
            }
            context.addFilter(new FilterHolder(filterDef.getFilter()), filterDef.getPathSpec(), EnumSet.allOf(DispatcherType.class));
        }
    }

    private static InetSocketAddress getAddress(String name, ServerConnector connector) {
        if (connector == null) {
            throw new IllegalStateException(name + " connector is not configured");
        }
        return new InetSocketAddress(connector.getHost(), connector.getLocalPort());
    }

    private void verifyAddressConfiguration() {
        if (this.httpAddress == null && this.httpsAddress == null) {
            throw new IllegalStateException("Either HTTP or HTTPS address must be configured to run the server");
        }
    }

    @Override
    public int allThreads() {
        if (this.getJetty() != null) {
            return this.getJetty().getThreadPool().getThreads();
        }
        return -1;
    }

    @Override
    public int idleThreads() {
        if (this.getJetty() != null) {
            return this.getJetty().getThreadPool().getIdleThreads();
        }
        return -1;
    }

    private static class FilterDefinition {
        private final Filter filter;
        private final String pathSpec;

        FilterDefinition(Filter filter, String pathSpec) {
            this.filter = filter;
            this.pathSpec = pathSpec;
        }

        public boolean matches(Filter filter, String pathSpec) {
            return filter == this.filter && pathSpec.equals(this.pathSpec);
        }

        public Filter getFilter() {
            return this.filter;
        }

        String getPathSpec() {
            return this.pathSpec;
        }
    }
}

