/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.httpv2.driver;

import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;

class DriverToInternalLogProvider
implements Logging {
    private final InternalLogProvider logProvider;

    DriverToInternalLogProvider(InternalLogProvider logProvider) {
        this.logProvider = logProvider;
    }

    public Logger getLog(String name) {
        return new DriverLogMappingLogger(this.logProvider.getLog(name));
    }

    static class DriverLogMappingLogger
    implements Logger {
        private final InternalLog log;

        DriverLogMappingLogger(InternalLog log) {
            this.log = log;
        }

        public void error(String message, Throwable cause) {
            this.log.error(message, cause);
        }

        public void info(String message, Object ... params) {
            this.log.info(message, params);
        }

        public void warn(String message, Object ... params) {
            this.log.warn(message, params);
        }

        public void warn(String message, Throwable cause) {
            this.log.warn(message, cause);
        }

        public void debug(String message, Object ... params) {
            this.log.debug(message, params);
        }

        public void debug(String message, Throwable throwable) {
            this.log.debug(message, throwable);
        }

        public void trace(String message, Object ... params) {
            this.log.debug(message, params);
        }

        public boolean isTraceEnabled() {
            return false;
        }

        public boolean isDebugEnabled() {
            return this.log.isDebugEnabled();
        }
    }
}

