/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.httpv2.driver;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.util.Futures;

class DeferredChannelFuture
implements ChannelFuture {
    private final Logger logger;
    private final CompletableFuture<GenericFutureListener> listenerFuture = new CompletableFuture();

    public DeferredChannelFuture(CompletionStage<ChannelFuture> channelFutureCompletionStage, Logging logging) {
        this.logger = logging.getLog(this.getClass());
        ((CompletableFuture)this.listenerFuture.thenCompose(ignored -> channelFutureCompletionStage)).whenComplete((channelFuture, throwable) -> {
            GenericFutureListener listener = this.listenerFuture.join();
            if (throwable != null) {
                throwable = Futures.completionExceptionCause((Throwable)throwable);
                try {
                    listener.operationComplete((Future)new FailedChannelFuture((Throwable)throwable));
                }
                catch (Throwable e) {
                    this.logger.error("An error occurred while notifying listener.", e);
                }
            } else {
                channelFuture.addListener(listener);
            }
        });
    }

    public Channel channel() {
        return null;
    }

    public boolean isSuccess() {
        return false;
    }

    public boolean isCancellable() {
        return false;
    }

    public Throwable cause() {
        return null;
    }

    public ChannelFuture addListener(GenericFutureListener<? extends Future<? super Void>> listener) {
        this.listenerFuture.complete(listener);
        return this;
    }

    @SafeVarargs
    public final ChannelFuture addListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
        return null;
    }

    public ChannelFuture removeListener(GenericFutureListener<? extends Future<? super Void>> listener) {
        return null;
    }

    @SafeVarargs
    public final ChannelFuture removeListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
        return null;
    }

    public ChannelFuture sync() {
        return null;
    }

    public ChannelFuture syncUninterruptibly() {
        return null;
    }

    public ChannelFuture await() {
        return null;
    }

    public ChannelFuture awaitUninterruptibly() {
        return null;
    }

    public boolean await(long timeout, TimeUnit unit) {
        return false;
    }

    public boolean await(long timeoutMillis) {
        return false;
    }

    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        return false;
    }

    public boolean awaitUninterruptibly(long timeoutMillis) {
        return false;
    }

    public Void getNow() {
        return null;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public boolean isCancelled() {
        return false;
    }

    public boolean isDone() {
        return false;
    }

    public Void get() {
        return null;
    }

    public Void get(long timeout, TimeUnit unit) {
        return null;
    }

    public boolean isVoid() {
        return false;
    }

    private record FailedChannelFuture(Throwable throwable) implements ChannelFuture
    {
        public Channel channel() {
            return null;
        }

        public boolean isSuccess() {
            return false;
        }

        public boolean isCancellable() {
            return false;
        }

        public Throwable cause() {
            return this.throwable;
        }

        public ChannelFuture addListener(GenericFutureListener<? extends Future<? super Void>> listener) {
            return null;
        }

        @SafeVarargs
        public final ChannelFuture addListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
            return null;
        }

        public ChannelFuture removeListener(GenericFutureListener<? extends Future<? super Void>> listener) {
            return null;
        }

        @SafeVarargs
        public final ChannelFuture removeListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
            return null;
        }

        public ChannelFuture sync() {
            return null;
        }

        public ChannelFuture syncUninterruptibly() {
            return null;
        }

        public ChannelFuture await() {
            return null;
        }

        public ChannelFuture awaitUninterruptibly() {
            return null;
        }

        public boolean await(long timeout, TimeUnit unit) {
            return false;
        }

        public boolean await(long timeoutMillis) {
            return false;
        }

        public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
            return false;
        }

        public boolean awaitUninterruptibly(long timeoutMillis) {
            return false;
        }

        public Void getNow() {
            return null;
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isDone() {
            return true;
        }

        public Void get() {
            return null;
        }

        public Void get(long timeout, TimeUnit unit) {
            return null;
        }

        public boolean isVoid() {
            return false;
        }
    }
}

