/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.httpv2;

import java.net.URI;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.neo4j.configuration.Config;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.FatalDiscoveryException;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.exceptions.TransientException;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.httpv2.request.AccessMode;
import org.neo4j.server.httpv2.request.QueryRequest;
import org.neo4j.server.httpv2.request.ResultContainer;
import org.neo4j.server.httpv2.response.HttpErrorResponse;
import org.neo4j.server.rest.dbms.AuthorizationHeaders;

@Path(value="/{databaseName}/query/v2")
public class QueryResource {
    public static final String NAME = "query";
    private static final String DB_PATH_PARAM_NAME = "databaseName";
    public static final String API_PATH_FRAGMENT = "query/v2";
    static final String FULL_PATH = "/{databaseName}/query/v2";
    private final Driver driver;

    public QueryResource(@Context Driver driver) {
        this.driver = driver;
    }

    @POST
    @Produces(value={"application/json", "application/vnd.neo4j.query"})
    @Consumes(value={"application/json", "application/vnd.neo4j.query"})
    public Response execute(@PathParam(value="databaseName") String databaseName, QueryRequest request, @Context HttpServletRequest rawRequest, @Context HttpHeaders headers) {
        Response response;
        SessionConfig sessionConfig = this.buildSessionConfig(request, databaseName);
        AuthToken sessionAuthToken = QueryResource.extractAuthToken(rawRequest);
        if (sessionAuthToken == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Session session = (Session)this.driver.session(Session.class, sessionConfig, sessionAuthToken);
        try {
            Result result = session.run(request.statement(), request.parameters());
            ResultContainer resultAndSession = new ResultContainer(result, session, request);
            response = Response.accepted((Object)resultAndSession).build();
        }
        catch (FatalDiscoveryException ex) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)HttpErrorResponse.fromDriverException((Neo4jException)ex)).build();
        }
        catch (ClientException | TransientException clientException) {
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)HttpErrorResponse.fromDriverException((Neo4jException)clientException)).build();
        }
        catch (Exception clientException) {
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)clientException).build();
        }
        if (response.getStatus() != Response.Status.ACCEPTED.getStatusCode()) {
            this.closeSession(session);
        }
        return response;
    }

    private void closeSession(Session session) {
        if (session != null) {
            session.close();
        }
    }

    private SessionConfig buildSessionConfig(QueryRequest request, String databaseName) {
        SessionConfig.Builder sessionConfigBuilder = SessionConfig.builder().withDatabase(databaseName);
        if (request.bookmarks() != null && !request.bookmarks().isEmpty()) {
            sessionConfigBuilder.withBookmarks((Iterable)request.bookmarks().stream().map(Bookmark::from).collect(Collectors.toList()));
        }
        if (request.impersonatedUser() != null && !request.impersonatedUser().isBlank()) {
            sessionConfigBuilder.withImpersonatedUser(request.impersonatedUser().trim());
        }
        if (request.accessMode() != null) {
            sessionConfigBuilder.withDefaultAccessMode(AccessMode.toDriverAccessMode(request.accessMode()));
        }
        return sessionConfigBuilder.build();
    }

    private static AuthToken extractAuthToken(HttpServletRequest request) {
        if ("BASIC".equals(request.getAuthType())) {
            String[] decoded = AuthorizationHeaders.decode(request.getHeader("Authorization"));
            return decoded != null ? AuthTokens.basic((String)decoded[0], (String)decoded[1]) : null;
        }
        return AuthTokens.none();
    }

    public static String absoluteDatabaseTransactionPath(Config config) {
        return ((URI)config.get(ServerSettings.db_api_path)).getPath() + FULL_PATH;
    }
}

