/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.httpv2.request;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.function.Function;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.value.BooleanValue;
import org.neo4j.driver.internal.value.ListValue;
import org.neo4j.driver.internal.value.MapValue;
import org.neo4j.driver.internal.value.NullValue;
import org.neo4j.server.httpv2.response.format.CypherTypes;

public class ValueDeserializer
extends StdDeserializer<Value> {
    public ValueDeserializer() {
        super(Value.class);
    }

    public Value deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String name = p.nextFieldName();
        if (name.equals("$type")) {
            String typeString = p.nextTextValue();
            JsonToken nextToken = p.nextToken();
            if (nextToken.equals((Object)JsonToken.FIELD_NAME) && p.currentName().equals("_value")) {
                p.nextToken();
                if (typeString.equals(CypherTypes.List.name())) {
                    ListValue listValue = (ListValue)p.readValueAs(ListValue.class);
                    p.nextToken();
                    return listValue;
                }
                if (typeString.equals(CypherTypes.Map.name())) {
                    return (Value)p.readValueAs(MapValue.class);
                }
                if (typeString.equals(CypherTypes.Boolean.name())) {
                    BooleanValue boolValue = BooleanValue.fromBoolean((boolean)p.getBooleanValue());
                    p.nextToken();
                    return boolValue;
                }
                if (typeString.equals(CypherTypes.Null.name())) {
                    if (p.currentToken().equals((Object)JsonToken.VALUE_NULL)) {
                        p.nextToken();
                        return NullValue.NULL;
                    }
                    throw new JsonParseException("Expected 'null' value");
                }
                Function<String, Value> parser = CypherTypes.valueOf(typeString).getReader();
                if (parser != null) {
                    String stringValue = p.getValueAsString();
                    p.nextToken();
                    return parser.apply(stringValue);
                }
                throw new JsonParseException(String.format("Type %s is not a valid parameter type.", typeString));
            }
            throw new JsonParseException(String.format("Expecting field %s", "_value"));
        }
        throw new JsonParseException("Expected a typed value.");
    }
}

