/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.httpv2.driver;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.local.LocalAddress;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.time.Clock;
import org.neo4j.driver.AuthTokenManager;
import org.neo4j.driver.Logging;
import org.neo4j.driver.NotificationConfig;
import org.neo4j.driver.internal.BoltAgent;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.connection.ChannelConnectedListener;
import org.neo4j.driver.internal.async.connection.ChannelConnector;
import org.neo4j.driver.internal.async.connection.ChannelPipelineBuilder;
import org.neo4j.driver.internal.async.connection.ChannelPipelineBuilderImpl;
import org.neo4j.driver.internal.async.connection.HandshakeCompletedListener;
import org.neo4j.driver.internal.async.connection.NettyChannelInitializer;
import org.neo4j.driver.internal.async.inbound.ConnectTimeoutHandler;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.security.SecurityPlanImpl;
import org.neo4j.server.httpv2.driver.LocalChannelDriverFactory;

class LocalChannelConnector
implements ChannelConnector {
    private static final BoltServerAddress IGNORED_ADDRESS = new BoltServerAddress(LocalChannelDriverFactory.IGNORED_HTTP_DRIVER_URI);
    private final LocalAddress localAddress;
    private final Clock clock;
    private final Logging logging;
    private final String userAgent;
    private final BoltAgent boltAgent;
    private final NotificationConfig notificationConfig;
    private final AuthTokenManager authTokenManager;

    public LocalChannelConnector(LocalAddress localAddress, String userAgent, BoltAgent boltAgent, AuthTokenManager authTokenManager, NotificationConfig notificationConfig, Clock clock, Logging logging) {
        this.localAddress = localAddress;
        this.userAgent = userAgent;
        this.boltAgent = boltAgent;
        this.notificationConfig = notificationConfig;
        this.authTokenManager = authTokenManager;
        this.clock = clock;
        this.logging = logging;
    }

    public ChannelFuture connect(BoltServerAddress ignored, Bootstrap bootstrap) {
        bootstrap.handler((ChannelHandler)new NettyChannelInitializer(IGNORED_ADDRESS, SecurityPlanImpl.insecure(), 1000, this.authTokenManager, this.clock, this.logging));
        ChannelFuture channelConnected = bootstrap.connect((SocketAddress)this.localAddress);
        Channel channel = channelConnected.channel();
        ChannelPromise handshakeCompleted = channel.newPromise();
        ChannelPromise connectionInitialized = channel.newPromise();
        this.installChannelConnectedListeners(channelConnected, handshakeCompleted);
        this.installHandshakeCompletedListeners(handshakeCompleted, connectionInitialized);
        return connectionInitialized;
    }

    private void installChannelConnectedListeners(ChannelFuture channelConnected, ChannelPromise handshakeCompleted) {
        ChannelPipeline pipeline = channelConnected.channel().pipeline();
        channelConnected.addListener(future -> pipeline.addFirst(new ChannelHandler[]{new ConnectTimeoutHandler(1000L)}));
        channelConnected.addListener((GenericFutureListener)new ChannelConnectedListener(IGNORED_ADDRESS, (ChannelPipelineBuilder)new ChannelPipelineBuilderImpl(), handshakeCompleted, this.logging));
    }

    private void installHandshakeCompletedListeners(ChannelPromise handshakeCompleted, ChannelPromise connectionInitialized) {
        ChannelPipeline pipeline = handshakeCompleted.channel().pipeline();
        handshakeCompleted.addListener(future -> pipeline.remove(ConnectTimeoutHandler.class));
        handshakeCompleted.addListener((GenericFutureListener)new HandshakeCompletedListener(this.userAgent, this.boltAgent, RoutingContext.EMPTY, connectionInitialized, this.notificationConfig, this.clock));
    }
}

