/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.jolt;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.List;
import org.neo4j.server.http.cypher.format.jolt.Sigil;

final class JoltListSerializer
extends StdSerializer<List<?>> {
    static final CollectionLikeType HANDLED_TYPE = TypeFactory.defaultInstance().constructCollectionLikeType(List.class, Object.class);

    JoltListSerializer() {
        super((JavaType)HANDLED_TYPE);
    }

    public void serialize(List<?> list, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject(list);
        generator.writeFieldName(Sigil.LIST.getValue());
        generator.writeStartArray(list);
        for (Object entry : list) {
            generator.writeObject(entry);
        }
        generator.writeEndArray();
        generator.writeEndObject();
    }
}

