/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.server.config.AuthConfigProvider;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.rest.discovery.DiscoverableURIs;
import org.neo4j.server.rest.discovery.DiscoveryService;
import org.neo4j.server.rest.web.AccessiblePathFilter;
import org.neo4j.server.rest.web.CorsFilter;
import org.neo4j.server.web.Injectable;
import org.neo4j.server.web.WebServer;

public class DBMSModule
implements ServerModule {
    private static final String ROOT_PATH = "/";
    private final WebServer webServer;
    private final Config config;
    private final Supplier<DiscoverableURIs> discoverableURIs;
    private final InternalLogProvider logProvider;
    private final AuthConfigProvider authConfigProvider;

    public DBMSModule(WebServer webServer, Config config, Supplier<DiscoverableURIs> discoverableURIs, InternalLogProvider logProvider, AuthConfigProvider authConfigProvider) {
        this.webServer = webServer;
        this.config = config;
        this.discoverableURIs = discoverableURIs;
        this.logProvider = logProvider;
        this.authConfigProvider = authConfigProvider;
    }

    @Override
    public void start() {
        this.webServer.addJAXRSClasses(Collections.singletonList(DiscoveryService.class), ROOT_PATH, List.of(Injectable.injectable(DiscoverableURIs.class, this.discoverableURIs.get()), Injectable.injectable(AuthConfigProvider.class, this.authConfigProvider)));
        this.webServer.addJAXRSClasses(this.jaxRsClasses(), ROOT_PATH, null);
        this.webServer.addFilter(new CorsFilter(this.logProvider, (String)this.config.get(ServerSettings.http_access_control_allow_origin)), "/*");
        this.webServer.addFilter(new AccessiblePathFilter(this.logProvider, (List)this.config.get(ServerSettings.http_paths_blacklist)), "/*");
    }

    @Override
    public void stop() {
        this.webServer.removeJAXRSClasses(this.jaxRsClasses(), ROOT_PATH);
    }

    private List<Class<?>> jaxRsClasses() {
        if (((Boolean)this.config.get(GraphDatabaseSettings.auth_enabled)).booleanValue()) {
            return Collections.singletonList(JacksonJsonProvider.class);
        }
        return Collections.emptyList();
    }
}

