/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.util.Collections;
import java.util.List;
import org.neo4j.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.web.WebServer;

public class ThirdPartyJAXRSModule
implements ServerModule {
    private final Config config;
    private final WebServer webServer;
    private List<ThirdPartyJaxRsPackage> packages;
    private final Log log;

    public ThirdPartyJAXRSModule(WebServer webServer, Config config, LogProvider logProvider) {
        this.webServer = webServer;
        this.config = config;
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public void start() {
        this.packages = (List)this.config.get(ServerSettings.third_party_packages);
        for (ThirdPartyJaxRsPackage tpp : this.packages) {
            List<String> packageNames = ThirdPartyJAXRSModule.packagesFor(tpp);
            this.webServer.addJAXRSPackages(packageNames, tpp.getMountPoint(), null);
            this.log.info("Mounted unmanaged extension [%s] at [%s]", new Object[]{tpp.getPackageName(), tpp.getMountPoint()});
        }
    }

    private static List<String> packagesFor(ThirdPartyJaxRsPackage tpp) {
        return Collections.singletonList(tpp.getPackageName());
    }

    @Override
    public void stop() {
        if (this.packages == null) {
            return;
        }
        for (ThirdPartyJaxRsPackage tpp : this.packages) {
            this.webServer.removeJAXRSPackages(ThirdPartyJAXRSModule.packagesFor(tpp), tpp.getMountPoint());
        }
    }
}

