/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.servlet.Servlet;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.neo4j.server.bind.ComponentsBinder;
import org.neo4j.server.http.error.MediaTypeExceptionMapper;
import org.neo4j.server.http.error.Neo4jHttpExceptionMapper;
import org.neo4j.server.web.Injectable;
import org.neo4j.server.web.XForwardFilter;

public class JaxRsServletHolderFactory {
    private final Set<String> packages = new HashSet<String>();
    private final Set<Class<?>> classes = new HashSet();
    private final List<Injectable<?>> injectables = new ArrayList();

    public JaxRsServletHolderFactory() {
        this.classes.add(Neo4jHttpExceptionMapper.class);
        this.classes.add(MediaTypeExceptionMapper.class);
        this.classes.add(JacksonJsonProvider.class);
    }

    public void addPackages(List<String> packages, Collection<Injectable<?>> injectableProviders) {
        this.packages.addAll(packages);
        if (injectableProviders != null) {
            this.injectables.addAll(injectableProviders);
        }
    }

    public void addClasses(List<Class<?>> classes, Collection<Injectable<?>> injectableProviders) {
        this.classes.addAll(classes);
        if (injectableProviders != null) {
            this.injectables.addAll(injectableProviders);
        }
    }

    public void removePackages(List<String> packages) {
        this.packages.removeAll(packages);
    }

    public void removeClasses(List<Class<?>> classes) {
        this.classes.removeAll(classes);
    }

    public ServletHolder create(ComponentsBinder binder, boolean wadlEnabled) {
        for (Injectable<?> injectable : this.injectables) {
            Supplier<Object> getValue = injectable::getValue;
            Class<?> type = injectable.getType();
            binder.addLazyBinding(getValue, type);
        }
        ResourceConfig resourceConfig = new ResourceConfig().register((Object)binder).register(XForwardFilter.class).packages(this.packages.toArray(new String[0])).registerClasses(this.classes).property("jersey.config.server.wadl.disableWadl", (Object)String.valueOf(!wadlEnabled));
        ServletContainer container = new ServletContainer(resourceConfig);
        return new ServletHolder((Servlet)container);
    }
}

