/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.output.json;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.internal.helpers.collection.IterableWrapper;
import org.neo4j.server.http.cypher.TransactionStateChecker;
import org.neo4j.server.http.cypher.format.api.RecordEvent;
import org.neo4j.server.http.cypher.format.output.json.ResultDataContentWriter;

class GraphExtractionWriter
implements ResultDataContentWriter {
    GraphExtractionWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(JsonGenerator out, RecordEvent recordEvent, TransactionStateChecker txStateChecker) throws IOException {
        HashSet<Node> nodes = new HashSet<Node>();
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        GraphExtractionWriter.extract(nodes, relationships, GraphExtractionWriter.map(recordEvent));
        out.writeObjectFieldStart("graph");
        try {
            GraphExtractionWriter.writeNodes(out, nodes, txStateChecker);
            GraphExtractionWriter.writeRelationships(out, relationships, txStateChecker);
        }
        finally {
            out.writeEndObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeNodes(JsonGenerator out, Iterable<Node> nodes, TransactionStateChecker txStateChecker) throws IOException {
        out.writeArrayFieldStart("nodes");
        try {
            for (Node node : nodes) {
                out.writeStartObject();
                try {
                    long nodeId = node.getId();
                    out.writeStringField("id", Long.toString(nodeId));
                    if (txStateChecker.isNodeDeletedInCurrentTx(nodeId)) {
                        GraphExtractionWriter.markDeleted(out);
                        continue;
                    }
                    out.writeArrayFieldStart("labels");
                    try {
                        for (Label label : node.getLabels()) {
                            out.writeString(label.name());
                        }
                    }
                    finally {
                        out.writeEndArray();
                    }
                    GraphExtractionWriter.writeProperties(out, (Entity)node);
                }
                finally {
                    out.writeEndObject();
                }
            }
        }
        finally {
            out.writeEndArray();
        }
    }

    private static void markDeleted(JsonGenerator out) throws IOException {
        out.writeBooleanField("deleted", Boolean.TRUE.booleanValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRelationships(JsonGenerator out, Iterable<Relationship> relationships, TransactionStateChecker txStateChecker) throws IOException {
        out.writeArrayFieldStart("relationships");
        try {
            for (Relationship relationship : relationships) {
                out.writeStartObject();
                try {
                    long relationshipId = relationship.getId();
                    out.writeStringField("id", Long.toString(relationshipId));
                    if (txStateChecker.isRelationshipDeletedInCurrentTx(relationshipId)) {
                        GraphExtractionWriter.markDeleted(out);
                        continue;
                    }
                    out.writeStringField("type", relationship.getType().name());
                    out.writeStringField("startNode", Long.toString(relationship.getStartNode().getId()));
                    out.writeStringField("endNode", Long.toString(relationship.getEndNode().getId()));
                    GraphExtractionWriter.writeProperties(out, (Entity)relationship);
                }
                finally {
                    out.writeEndObject();
                }
            }
        }
        finally {
            out.writeEndArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeProperties(JsonGenerator out, Entity container) throws IOException {
        out.writeObjectFieldStart("properties");
        try {
            for (Map.Entry property : container.getAllProperties().entrySet()) {
                out.writeObjectField((String)property.getKey(), property.getValue());
            }
        }
        finally {
            out.writeEndObject();
        }
    }

    private static void extract(Set<Node> nodes, Set<Relationship> relationships, Iterable<?> source) {
        for (Object item : source) {
            if (item instanceof Node) {
                nodes.add((Node)item);
            } else if (item instanceof Relationship) {
                Relationship relationship = (Relationship)item;
                relationships.add(relationship);
                nodes.add(relationship.getStartNode());
                nodes.add(relationship.getEndNode());
            }
            if (item instanceof Path) {
                Path path = (Path)item;
                for (Node node : path.nodes()) {
                    nodes.add(node);
                }
                for (Relationship relationship : path.relationships()) {
                    relationships.add(relationship);
                }
                continue;
            }
            if (item instanceof Map) {
                GraphExtractionWriter.extract(nodes, relationships, ((Map)item).values());
                continue;
            }
            if (!(item instanceof Iterable)) continue;
            GraphExtractionWriter.extract(nodes, relationships, (Iterable)item);
        }
    }

    private static Iterable<?> map(final RecordEvent recordEvent) {
        return new IterableWrapper<Object, String>(recordEvent.getColumns()){

            protected Object underlyingObjectToObject(String key) {
                return recordEvent.getValue(key);
            }
        };
    }
}

