/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.server.http.cypher.TransitionalTxManagementKernelTransaction;

public class TransactionStateChecker {
    private final IsNodeDeletedInCurrentTx nodeCheck;
    private final IsRelationshipDeletedInCurrentTx relCheck;

    public TransactionStateChecker(IsNodeDeletedInCurrentTx nodeCheck, IsRelationshipDeletedInCurrentTx relCheck) {
        this.nodeCheck = nodeCheck;
        this.relCheck = relCheck;
    }

    public static TransactionStateChecker create(TransitionalTxManagementKernelTransaction transaction) {
        KernelTransactionImplementation tx = (KernelTransactionImplementation)transaction.getInternalTransaction().kernelTransaction();
        return new TransactionStateChecker(nodeId -> tx.hasTxStateWithChanges() && tx.txState().nodeIsDeletedInThisTx(nodeId), relId -> tx.hasTxStateWithChanges() && tx.txState().relationshipIsDeletedInThisTx(relId));
    }

    public boolean isNodeDeletedInCurrentTx(long id) {
        return this.nodeCheck.test(id);
    }

    public boolean isRelationshipDeletedInCurrentTx(long id) {
        return this.relCheck.test(id);
    }

    @FunctionalInterface
    public static interface IsRelationshipDeletedInCurrentTx {
        public boolean test(long var1);
    }

    @FunctionalInterface
    public static interface IsNodeDeletedInCurrentTx {
        public boolean test(long var1);
    }
}

