/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.ObjectToRepresentationConverter;
import org.neo4j.server.rest.repr.PathRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;

public class MapRepresentation
extends MappingRepresentation {
    private final Map<String, Object> value;

    public MapRepresentation(Map value) {
        super(RepresentationType.MAP);
        this.value = value;
    }

    protected void serialize(MappingSerializer serializer) {
        for (Map.Entry<String, Object> entry : this.value.entrySet()) {
            Representation representation;
            String keyString;
            Object val = entry.getValue();
            String string = keyString = entry.getKey() == null ? "null" : entry.getKey();
            if (val instanceof Number) {
                serializer.putNumber(keyString, (Number)val);
                continue;
            }
            if (val instanceof Boolean) {
                serializer.putBoolean(keyString, ((Boolean)val).booleanValue());
                continue;
            }
            if (val instanceof String) {
                serializer.putString(keyString, (String)val);
                continue;
            }
            if (val instanceof Path) {
                representation = new PathRepresentation((Path)val);
                serializer.putMapping(keyString, representation);
                continue;
            }
            if (val instanceof Iterable) {
                serializer.putList(keyString, ObjectToRepresentationConverter.getListRepresentation((Iterable)val));
                continue;
            }
            if (val instanceof Map) {
                serializer.putMapping(keyString, ObjectToRepresentationConverter.getMapRepresentation((Map)val));
                continue;
            }
            if (val == null) {
                serializer.putString(keyString, null);
                continue;
            }
            if (val.getClass().isArray()) {
                Object[] objects = MapRepresentation.toArray(val);
                serializer.putList(keyString, ObjectToRepresentationConverter.getListRepresentation(Arrays.asList(objects)));
                continue;
            }
            if (val instanceof Node || val instanceof Relationship) {
                representation = ObjectToRepresentationConverter.getSingleRepresentation(val);
                serializer.putMapping(keyString, (MappingRepresentation)representation);
                continue;
            }
            throw new IllegalArgumentException("Unsupported value type: " + val.getClass());
        }
    }

    private static Object[] toArray(Object val) {
        int length = Array.getLength(val);
        Object[] objects = new Object[length];
        for (int i = 0; i < length; ++i) {
            objects[i] = Array.get(val, i);
        }
        return objects;
    }
}

