/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.http.cypher.OutputEventStream;
import org.neo4j.server.http.cypher.TransactionHandle;
import org.neo4j.server.http.cypher.format.api.FailureEvent;
import org.neo4j.server.http.cypher.format.api.OutputEvent;
import org.neo4j.server.http.cypher.format.api.OutputEventSource;
import org.neo4j.server.http.cypher.format.api.RecordEvent;
import org.neo4j.server.http.cypher.format.api.Statement;
import org.neo4j.server.http.cypher.format.api.StatementEndEvent;
import org.neo4j.server.http.cypher.format.api.StatementStartEvent;
import org.neo4j.server.http.cypher.format.api.TransactionInfoEvent;
import org.neo4j.server.http.cypher.format.api.TransactionNotificationState;
import org.neo4j.server.http.cypher.format.api.TransactionUriScheme;

class OutputEventStreamImpl
implements OutputEventSource,
OutputEventStream {
    private final Consumer<OutputEventStream> startListener;
    private final Map<String, Object> parameters;
    private final TransactionHandle transactionHandle;
    private final TransactionUriScheme uriInfo;
    private Consumer<OutputEvent> eventListener;

    OutputEventStreamImpl(Map<String, Object> parameters, TransactionHandle transactionHandle, TransactionUriScheme uriInfo, Consumer<OutputEventStream> startListener) {
        this.parameters = parameters;
        this.transactionHandle = transactionHandle;
        this.startListener = startListener;
        this.uriInfo = uriInfo;
    }

    @Override
    public void produceEvents(Consumer<OutputEvent> eventListener) {
        this.eventListener = eventListener;
        this.startListener.accept(this);
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public void writeStatementStart(Statement statement, List<String> columns) {
        this.notifyListener(new StatementStartEvent(statement, columns));
    }

    @Override
    public void writeStatementEnd(QueryExecutionType queryExecutionType, QueryStatistics queryStatistics, ExecutionPlanDescription executionPlanDescription, Iterable<Notification> notifications) {
        this.notifyListener(new StatementEndEvent(queryExecutionType, queryStatistics, executionPlanDescription, notifications));
    }

    @Override
    public void writeRecord(List<String> columns, Function<String, Object> valueSupplier) {
        this.notifyListener(new RecordEvent(columns, valueSupplier));
    }

    @Override
    public void writeTransactionInfo(TransactionNotificationState notification, URI commitUri, long expirationTimestamp) {
        this.notifyListener(new TransactionInfoEvent(notification, commitUri, expirationTimestamp));
    }

    @Override
    public void writeFailure(Status status, String message) {
        this.notifyListener(new FailureEvent(status, message));
    }

    private void notifyListener(OutputEvent event) {
        this.eventListener.accept(event);
    }

    @Override
    public TransactionUriScheme getUriInfo() {
        return this.uriInfo;
    }

    @Override
    public TransactionHandle getTransactionHandle() {
        return this.transactionHandle;
    }
}

