/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.output.json;

import com.fasterxml.jackson.core.JsonFactory;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.neo4j.server.http.cypher.TransactionHandle;
import org.neo4j.server.http.cypher.format.DefaultJsonFactory;
import org.neo4j.server.http.cypher.format.api.OutputEventSource;
import org.neo4j.server.http.cypher.format.api.TransactionUriScheme;
import org.neo4j.server.http.cypher.format.common.Neo4jJsonCodec;
import org.neo4j.server.http.cypher.format.output.json.ExecutionResultSerializer;

@Provider
@Produces(value={"application/json;qs=0.9"})
public class JsonMessageBodyWriter
implements MessageBodyWriter<OutputEventSource> {
    public static final String JSON_MIME_TYPE_WITH_QUALITY = "application/json;qs=0.9";

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return OutputEventSource.class.isAssignableFrom(type);
    }

    public void writeTo(OutputEventSource outputEventSource, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws WebApplicationException {
        TransactionHandle transaction = outputEventSource.getTransactionHandle();
        Map<String, Object> parameters = outputEventSource.getParameters();
        TransactionUriScheme uriInfo = outputEventSource.getUriInfo();
        JsonFactory jsonFactory = DefaultJsonFactory.INSTANCE.get();
        ExecutionResultSerializer serializer = new ExecutionResultSerializer(transaction, parameters, uriInfo.dbUri(), Neo4jJsonCodec.class, jsonFactory, entityStream);
        outputEventSource.produceEvents(serializer::handleEvent);
    }
}

