/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.ssl;

import java.util.List;
import java.util.UUID;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.server.security.ssl.HttpsRequestCustomizer;
import org.neo4j.server.web.HttpConnectorFactory;
import org.neo4j.server.web.JettyThreadCalculator;
import org.neo4j.ssl.SslPolicy;

public class SslSocketConnectorFactory
extends HttpConnectorFactory {
    private static final String NAME = "https";
    private final HttpConfiguration.Customizer requestCustomizer;

    public SslSocketConnectorFactory(NetworkConnectionTracker connectionTracker, Config config) {
        super(NAME, connectionTracker, config);
        this.requestCustomizer = new HttpsRequestCustomizer(config);
    }

    @Override
    protected HttpConfiguration createHttpConfig() {
        HttpConfiguration httpConfig = super.createHttpConfig();
        httpConfig.addCustomizer(this.requestCustomizer);
        return httpConfig;
    }

    public ServerConnector createConnector(Server server, SslPolicy sslPolicy, SocketAddress address, JettyThreadCalculator jettyThreadCalculator) {
        SslConnectionFactory sslConnectionFactory = this.createSslConnectionFactory(sslPolicy);
        return this.createConnector(server, address, jettyThreadCalculator, new ConnectionFactory[]{sslConnectionFactory, this.createHttpConnectionFactory()});
    }

    private SslConnectionFactory createSslConnectionFactory(SslPolicy sslPolicy) {
        String[] protocols;
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        String password = UUID.randomUUID().toString();
        sslContextFactory.setKeyStore(sslPolicy.getKeyStore(password.toCharArray(), password.toCharArray()));
        sslContextFactory.setKeyStorePassword(password);
        sslContextFactory.setKeyManagerPassword(password);
        List ciphers = sslPolicy.getCipherSuites();
        if (ciphers != null) {
            sslContextFactory.setIncludeCipherSuites(ciphers.toArray(new String[0]));
            sslContextFactory.setExcludeCipherSuites(new String[0]);
        }
        if ((protocols = sslPolicy.getTlsVersions()) != null) {
            sslContextFactory.setIncludeProtocols(protocols);
            sslContextFactory.setExcludeProtocols(new String[0]);
        }
        switch (sslPolicy.getClientAuth()) {
            case REQUIRE: {
                sslContextFactory.setNeedClientAuth(true);
                break;
            }
            case OPTIONAL: {
                sslContextFactory.setWantClientAuth(true);
                break;
            }
            case NONE: {
                sslContextFactory.setWantClientAuth(false);
                sslContextFactory.setNeedClientAuth(false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not supported: " + sslPolicy.getClientAuth());
            }
        }
        return new SslConnectionFactory((SslContextFactory)sslContextFactory, HttpVersion.HTTP_1_1.asString());
    }
}

