/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import org.eclipse.jetty.io.Connection;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.api.net.TrackedNetworkConnection;
import org.neo4j.server.web.JettyHttpConnection;
import org.neo4j.server.web.JettyHttpConnectionListener;

class JettyHttpConnectionListenerTest {
    private final NetworkConnectionTracker connectionTracker = (NetworkConnectionTracker)Mockito.mock(NetworkConnectionTracker.class);
    private final JettyHttpConnectionListener listener = new JettyHttpConnectionListener(this.connectionTracker);

    JettyHttpConnectionListenerTest() {
    }

    @Test
    void shouldNotifyAboutOpenConnection() {
        JettyHttpConnection connection = (JettyHttpConnection)Mockito.mock(JettyHttpConnection.class);
        this.listener.onOpened((Connection)connection);
        ((NetworkConnectionTracker)Mockito.verify((Object)this.connectionTracker)).add((TrackedNetworkConnection)connection);
        ((NetworkConnectionTracker)Mockito.verify((Object)this.connectionTracker, (VerificationMode)Mockito.never())).remove((TrackedNetworkConnection)ArgumentMatchers.any());
    }

    @Test
    void shouldNotifyAboutClosedConnection() {
        JettyHttpConnection connection = (JettyHttpConnection)Mockito.mock(JettyHttpConnection.class);
        this.listener.onClosed((Connection)connection);
        ((NetworkConnectionTracker)Mockito.verify((Object)this.connectionTracker, (VerificationMode)Mockito.never())).add((TrackedNetworkConnection)ArgumentMatchers.any());
        ((NetworkConnectionTracker)Mockito.verify((Object)this.connectionTracker)).remove((TrackedNetworkConnection)connection);
    }

    @Test
    void shouldIgnoreOpenConnectionOfUnknownType() {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        this.listener.onOpened(connection);
        ((NetworkConnectionTracker)Mockito.verify((Object)this.connectionTracker, (VerificationMode)Mockito.never())).add((TrackedNetworkConnection)ArgumentMatchers.any());
        ((NetworkConnectionTracker)Mockito.verify((Object)this.connectionTracker, (VerificationMode)Mockito.never())).remove((TrackedNetworkConnection)ArgumentMatchers.any());
    }

    @Test
    void shouldIgnoreClosedConnectionOfUnknownType() {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        this.listener.onClosed(connection);
        ((NetworkConnectionTracker)Mockito.verify((Object)this.connectionTracker, (VerificationMode)Mockito.never())).add((TrackedNetworkConnection)ArgumentMatchers.any());
        ((NetworkConnectionTracker)Mockito.verify((Object)this.connectionTracker, (VerificationMode)Mockito.never())).remove((TrackedNetworkConnection)ArgumentMatchers.any());
    }
}

