/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr.formats;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.server.rest.repr.formats.JsonFormat;

public class JsonInputTest {
    private final JsonFormat input = new JsonFormat();

    @Test
    public void canReadEmptyMap() throws Exception {
        Map map = this.input.readMap("{}", new String[0]);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)map);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)map.isEmpty(), (String)"map is not empty");
    }

    @Test
    public void canReadMapWithTwoValues() throws Exception {
        Map map = this.input.readMap("{\"key1\":\"value1\",     \"key2\":\"value11\"}", new String[0]);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)map);
        Assertions.assertThat((Map)map).containsEntry((Object)"key1", (Object)"value1");
        Assertions.assertThat((Map)map).containsEntry((Object)"key2", (Object)"value11");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)map.size(), (String)"map contained extra values");
    }

    @Test
    public void canReadMapWithNestedMap() throws Exception {
        Map map = this.input.readMap("{\"nested\": {\"key\": \"valuable\"}}", new String[0]);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)map);
        Assertions.assertThat((Map)map).containsKey((Object)"nested");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)map.size(), (String)"map contained extra values");
        Object nested = map.get("nested");
        Assertions.assertThat(nested).isInstanceOf(Map.class);
        Map nestedMap = (Map)nested;
        Assertions.assertThat((Map)nestedMap).containsEntry((Object)"key", (Object)"valuable");
    }

    @Test
    public void canReadStringWithLineBreaks() throws Exception {
        Map map = this.input.readMap("{\"key\": \"v1\\nv2\"}", new String[0]);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)map);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"v1\nv2", map.get("key"));
    }
}

