/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr.formats;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ServerListRepresentation;
import org.neo4j.server.rest.repr.ValueRepresentation;
import org.neo4j.server.rest.repr.formats.JsonFormat;

class JsonFormatTest {
    private OutputFormat json;

    JsonFormatTest() {
    }

    @BeforeEach
    void createOutputFormat() throws Exception {
        this.json = new OutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://localhost/"));
    }

    @Test
    void canFormatString() {
        String entity = this.json.assemble((Representation)ValueRepresentation.string((String)"expected value"));
        Assertions.assertEquals((Object)"\"expected value\"", (Object)entity);
    }

    @Test
    void canFormatListOfStrings() {
        String entity = this.json.assemble((Representation)ListRepresentation.strings((String[])new String[]{"hello", "world"}));
        String expectedString = JsonHelper.createJsonFrom(Arrays.asList("hello", "world"));
        Assertions.assertEquals((Object)expectedString, (Object)entity);
    }

    @Test
    void canFormatInteger() {
        String entity = this.json.assemble((Representation)ValueRepresentation.number((int)10));
        Assertions.assertEquals((Object)"10", (Object)entity);
    }

    @Test
    void canFormatEmptyObject() {
        String entity = this.json.assemble((Representation)new MappingRepresentation("empty"){

            protected void serialize(MappingSerializer serializer) {
            }
        });
        Assertions.assertEquals((Object)JsonHelper.createJsonFrom(Collections.emptyMap()), (Object)entity);
    }

    @Test
    void canFormatObjectWithStringField() {
        String entity = this.json.assemble((Representation)new MappingRepresentation("string"){

            protected void serialize(MappingSerializer serializer) {
                serializer.putString("key", "expected string");
            }
        });
        Assertions.assertEquals((Object)JsonHelper.createJsonFrom(Collections.singletonMap("key", "expected string")), (Object)entity);
    }

    @Test
    void canFormatObjectWithUriField() {
        String entity = this.json.assemble((Representation)new MappingRepresentation("uri"){

            protected void serialize(MappingSerializer serializer) {
                serializer.putRelativeUri("URL", "subpath");
            }
        });
        Assertions.assertEquals((Object)JsonHelper.createJsonFrom(Collections.singletonMap("URL", "http://localhost/subpath")), (Object)entity);
    }

    @Test
    void canFormatObjectWithNestedObject() {
        String entity = this.json.assemble((Representation)new MappingRepresentation("nesting"){

            protected void serialize(MappingSerializer serializer) {
                serializer.putMapping("nested", new MappingRepresentation("data"){

                    protected void serialize(MappingSerializer nested) {
                        nested.putString("data", "expected data");
                    }
                });
            }
        });
        Assertions.assertEquals((Object)JsonHelper.createJsonFrom(Collections.singletonMap("nested", Collections.singletonMap("data", "expected data"))), (Object)entity);
    }

    @Test
    void canFormatNestedMapsAndLists() throws Exception {
        String entity = this.json.assemble((Representation)new MappingRepresentation("test"){

            protected void serialize(MappingSerializer serializer) {
                ArrayList<1> maps = new ArrayList<1>();
                maps.add(new MappingRepresentation("map"){

                    protected void serialize(MappingSerializer serializer) {
                        serializer.putString("foo", "bar");
                    }
                });
                serializer.putList("foo", (ListRepresentation)new ServerListRepresentation(RepresentationType.MAP, maps));
            }
        });
        Assertions.assertEquals((Object)"bar", ((Map)((List)JsonHelper.jsonToMap((String)entity).get("foo")).get(0)).get("foo"));
    }
}

